% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qSIP_MAGs.R
\name{filter_na}
\alias{filter_na}
\title{Remove MAGs with NAs from atomX table}
\usage{
filter_na(atomX)
}
\arguments{
\item{atomX}{A list object created by \code{qSIP_atom_excess_MAGs()}}
}
\value{
A list of 2 data.frame objects without MAGs which have NAs. 'W' contains the weighted mean buoyant density (W) values for each OTU in each treatment/control. 'A' contains the atom fraction excess values for each OTU. For the 'A' table, the 'Z' column is buoyant density shift, and the 'A' column is atom fraction excess.
}
\description{
This function enables removing NAs from the atomX table.
}
\examples{
data(atomX)

\donttest{

### Remove NAs in atomX table
atomx_no_na = filter_na(atomX)
}

}
