% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequencing.R
\name{randomBulkSamples}
\alias{randomBulkSamples}
\title{Simulate multi-region bulk sampling}
\usage{
randomBulkSamples(tumor, nsamples, cube.length = 5, threshold = 0.05)
}
\arguments{
\item{tumor}{A list which is the output of \code{\link{simulateTumor}()}.}

\item{nsamples}{The number of bulk samples to take.}

\item{cube.length}{The side length of the cube of cells to be sampled.}

\item{threshold}{Only mutations with an allele frequency greater than the threshold will be included in the sample.}
}
\value{
A data frame with \code{nsamples} rows and columns corresponding to the mutations. 
The entries are the mutation allele frequency.
}
\description{
Simulate bulk sequencing data by taking a local sample from the tumor
and computing the variant allele frequencies of the various mutations.
}
\details{
This is the same as \code{\link{bulkSample}()}, except multiple samples are taken 
with random center points.
}
\examples{
out <- simulateTumor(N = 1000)
df <- randomBulkSamples(tumor = out, nsamples = 5, cube.length = 5, threshold = 0.05)

}
\author{
Phillip B. Nicol
}
