% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GP_cat.R
\name{GP.cat}
\alias{GP.cat}
\title{Estimation of single catalytic constant using Gaussian processes}
\usage{
GP.cat(method = T, RAM = F, time, dat, enz, subs, MM, catal,
  nrepeat = 10000, jump = 1, burning = 0, catal_m_v = c(1, 10000),
  sig, va)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{RAM}{Robust Adaptive MCMC options (default = F)}

\item{time}{total time of data}

\item{dat}{observed dataset (trajectory column)}

\item{enz}{enzyme concentrate}

\item{subs}{substrate concentrate}

\item{MM}{true value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{nrepeat}{total number of iteration (default=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{length of burning period ( default =0)}

\item{catal_m_v}{Catalytic prior gamma mean, variance(default=c(1,10000))}

\item{sig}{standard deviation of univariate Normal proposal distribution}

\item{va}{variance of dataset}
}
\value{
A vector of posterior samples of catalytic constant
}
\description{
The function estimates single catalytic constant using single data set
with an initial enzyme concentrations and substrate concentration.
The Gaussian processes is utilized for the likelihood function.
}
\details{
The function GP.cat generates a set of MCMC simulation samples
from the conditional posterior distribution of catalytic constant of
enzyme kinetics model. As the catalytic constant is only parameter to
be estimated in the function the user should assign MM constant as well as
initial enzyme concentration and substrate concentration. The prior
information for the parameter can be given. The GP.cat function can
select Robust Adaptive Metropolis (RAM) algorithm as well as
Metropolis-Hastings algorithm with random walk chain for MCMC procedure.
When “RAM” is assigned T then the function use RAM method and the “sig”
is used as initial standard deviation of normal proposal distribution.
When “RAM” is F, the function use Metropolis-Hastings algorithm with
random walk chain and the “sig” can be set to controlled proper mixing
and acceptance ratio of the parameter from the conditional posterior
distribution. The “va” is the variance of the Gaussian process. The
posterior samples are only stored with fixed interval according to
set "jump" to reduce serial correlation. The initial iterations are
removed for convergence. The “burning” is set the length of initial
iterations. The Gaussian process method is used for construction of
the likelihood.
}
\examples{
\dontrun{
data('Chymo_low')
time1=max(Chymo_low[,1])*1.01
sk_GPMH=GP.cat(method=TRUE,time=time1,dat=Chymo_low[,2],enz=4.4e+7,subs=4.4e+7
                      ,MM=4.4e+8,catal=0.05,nrepeat=10000,jump=1,burning=0
                      ,catal_m_v=c(1,10000),sig=0.016,va=var(Chymo_low[,2]))
# use RAM algorithm #
sk_GPRAM=GP.cat(method=TRUE,RAM=TRUE,time=time1,dat=Chymo_low[,2],enz=4.4e+7,subs=4.4e+7
                      ,MM=4.4e+8,catal=0.05,nrepeat=10000,jump=1,burning=0
                      ,catal_m_v=c(1,10000),sig=0.1,va=var(Chymo_low[,2]))
}

}
