% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i.qplot.R
\name{i.qplot}
\alias{i.qplot}
\title{Plot the Closest Series to a Given Timewise Quantile Series}
\usage{
i.qplot(x, prob = 0.5, box = 3, xtime = NULL)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{prob}{Probability, the quantile series of which is to be computed.
Default value is 0.5.}

\item{box}{Number of boxplots for the difference series between the selected series and the
timewise quantile with the given probability. The differences are divided into blocks.
Default value is 3.}

\item{xtime}{A vector with the values for the x labels. Default values are 1, 2, 3, ...}
}
\value{
A list containing:
\itemize{
\item standardized - A matrix containing standardized time series.
\item qts - The timewise quantile of order prob.
\item selected - The closest time series to the given timewise quantile series.
}
}
\description{
Use sum of absolute deviations to select the individual time series that is closest
to a given timewise quantile series.
}
\examples{
data(TaiwanAirBox032017)
output <-  i.qplot(TaiwanAirBox032017[,1:3])

}
