% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutcorcell.R
\name{mutcellsummary}
\alias{mutcellsummary}
\title{mutcellsummary}
\usage{
mutcellsummary(mutcell, mutmatrix, cellmatrix)
}
\arguments{
\item{mutcell}{The result of `mutcorcell` funtion.}

\item{mutmatrix}{A binary mutations,in which 1 represents any mutation occurs in a particular gene in a particular sample, otherwise the element is 0. matrix}

\item{cellmatrix}{Cell abundance matrix}
}
\value{
The result summaries have four columns. The first column is somatic mutant gene names, the second column is the immune cell names driven by the somatic mutation, the third column is the number of the immune cell, the fourth column is the mutation rate.
}
\description{
Function `mutcellsummary` is a generic function used to produce summaries of the results of `mutcorcell` function.
}
\examples{
mutcell<-GetExampleData("mutcell") # The result of `mutcorcell` funtion
cellmatrix<-GetExampleData("cellmatrix") # Cell abundance matrix
mutmatrix<-GetExampleData("mutmatrix") # A binary mutations matrix
summary<-mutcellsummary(mutcell = mutcell,mutmatrix = mutmatrix,cellmatrix=cellmatrix)
}
