% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-Host.R
\name{loadStates}
\alias{loadStates}
\title{loadStates}
\usage{
loadStates(lhost, dfStates, id = "ID", colStates)
}
\arguments{
\item{lhost}{a HostSet}

\item{dfStates}{a data.frame with host ID and states in columns and time as value}

\item{id}{colname for host ID}

\item{colStates}{colnames of States columns}
}
\value{
lhost updated
}
\description{
Load Hosts states
}
\examples{
path = system.file("extdata", "data-simul/", package="SMITIDstruct")
lhost <- list()
class(lhost) <- "hostSet"
lhost <- loadTree(lhost,paste(path,"/tree.txt",sep='')) 
obs <- read.table(paste(path,"/obs.txt",sep=''),header=TRUE, check.names=FALSE)
obs.states <- c(colnames(obs[-grep("ID|Tobs.*",colnames(obs))]))
lhost <- loadStates(lhost, obs, colStates=obs.states)
}
