% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RWO.R
\name{RWO}
\alias{RWO}
\title{Random Walk Oversampling (SMOTE)}
\usage{
RWO(x, y, n_needed = NULL)
}
\arguments{
\item{x}{feature matrix.}

\item{y}{a factor class variable with two classes.}

\item{n_needed}{vector of desired number of synthetic samples for each class.
A vector of integers for each class. Default is NULL meaning full balance.}
}
\value{
a list with resampled dataset.
 \item{x_new}{Resampled feature matrix.}
 \item{y_new}{Resampled target variable.}
 \item{x_syn}{Generated synthetic feature data.}
 \item{y_syn}{Generated synthetic label data.}
}
\description{
Resampling with RWO
}
\details{
RWO (Zhang and Li, 2014) is an oversampling method which generates data using
variable standard error in a way that it preserves the variances of all variables.

Can work with classes more than 2.
}
\examples{

set.seed(1)
x <- rbind(matrix(rnorm(2000, 3, 1), ncol = 2, nrow = 1000),
           matrix(rnorm(100, 5, 1), ncol = 2, nrow = 50))
y <- as.factor(c(rep("negative", 1000), rep("positive", 50)))

plot(x, col = y)

# resampling
m <- RWO(x = x, y = y)

plot(m$x_new, col = m$y_new)

}
\references{
Zhang, H., & Li, M. (2014). RWO-Sampling: A random walk over-sampling
approach to imbalanced data classification. Information Fusion, 20, 99-116.
}
\author{
Fatih Saglam, saglamf89@gmail.com
}
