% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilitiesCreate.R
\name{createAB}
\alias{createAB}
\alias{BsFromB}
\alias{BcolsFromBcolllist}
\title{Utilities for array creation}
\usage{
createAB(s, k = 3, m = NULL)

BsFromB(B, s = NULL, r = NULL, permlist = NULL, oneonly = TRUE)

BcolsFromBcolllist(Bcollist)
}
\arguments{
\item{s}{levels}

\item{k}{integer; determines the run size: the resulting array will have s^k runs}

\item{m}{the number of columns to be created}

\item{B}{n x m matrix}

\item{r}{number of copies}

\item{permlist}{permutation list}

\item{oneonly}{logical: permute all copies in the same way?}

\item{Bcollist}{list of candidate columns for He et al. (2018) construction}
}
\value{
\code{createAB} returns a list of s^k times m matrices A, B and D for the He, Cheng and Tang (2018) construction

\code{BsFromB} returns an rn x m matrix

\code{BcolsFromBcolllist} returns column numbers selected for matrix B
}
\description{
Utilities for array creation
}
\details{
\code{BcolsFromBcolllist} tries to create adequate unique matches from a list of suitable matches. For example, if four matches are needed and the list \code{list(1:2, 1:3, 4:6, 1)} holds the suitable matches for the four positions, the function would return the vector 2, 3, 4, 1.
}
\note{
\code{BsFromB} is currently not used.
}
\keyword{internal}
