% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som_dimR.R
\name{som_dimR}
\alias{som_dimR}
\title{Calculate map dimensions}
\usage{
som_dimR(dataset, type = "regular")
}
\arguments{
\item{dataset}{Experimental data}

\item{type}{Either "regular", "small" or "big" map (default ="regular")}
}
\value{
This function returns a list containing the number of rows, columns and overall map units
}
\description{
Generate SOM map dimensions according to Vesanto heuristic rules based on the first two
eigenvalues of the experimental data and their related eigenvectors
The function has been coded in R code starting from som_dim.m
script present in somtoolbox for Matlab by Vesanto and adapted for the use in the shiny app
}
\examples{
library(datasets)
som_dimR(iris[,1:4], type="small")
}
\references{
{J. Vesanto, J. Himberg, E. Alhoniemi, J. Parhankagas, SOM Toolbox for Matlab
5, Report A57, 2000, Available at: www.cis.hut.fi/projects/somtoolbox/package/papers/techrep.pdf
}
}
\seealso{
eigen, cor
}
\author{
Sabina Licen, Pierluigi Barbieri
}
