% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_single_E.R
\name{check_parameters}
\alias{check_parameters}
\title{Check if the parameter list contains all the parameters required for the computation.}
\usage{
check_parameters(parameters, response, covariate)
}
\arguments{
\item{parameters}{A list of parameters that contains all the required parameters in the model. If response is "binary", this list needs to contain "preva" which denotes the prevalence of the disease (or case to control ratio for case-control sampling). If response is continuous, the list needs to contain "TraitSD" and "TraitMean" which represent the standard deviation and mean of the continuous trait.
#' If covariate is not "none", a parameter "gammaG" needs to be defined to capture the dependence between the SNP and the covariate (through linear regression model if covariate is continuous, and logistic model if covariate is binary). If covariate is "binary", list needs to contains "pE" that defines the frequency of the covariate. If it is continuous, list needs to contain "muE" and "sigmaE" to define
#' its mean and standard deviation. The MAF is defined as "pG", with HWE assumed to hold.}

\item{response}{A string of either "binary" or "continuous", indicating the type of response/trait variable in the model.}

\item{covariate}{A string of either "binary", "continuous" or "none" indicating the type of covariate E in the model.}
}
\value{
TRUE or FALSE if all the parameters are correctly defined.
}
\description{
Check if the parameter list contains all the parameters required for the computation.
}
\examples{
parameters <- list(TraitMean = 0.3, TraitSD = 1, pG = 0.2, betaG = log(1.1),
betaE = log(1.1), muE = 0, sigmaE = 3, gammaG = log(2.1))

SPCompute::check_parameters(parameters, "continuous", "continuous")
}
