% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spei.R
\name{Generic-methods-for-spei-objects}
\alias{Generic-methods-for-spei-objects}
\alias{print.spei}
\alias{plot.spei}
\alias{summary.spei}
\title{Generic methods for \code{spei} objects.}
\usage{
\method{print}{spei}(x, ...)
\method{summary}{spei}(object, ...)
\method{plot}{spei}(x, ...)

\method{summary}{spei}(object, ...)

\method{plot}{spei}(x, ...)
}
\arguments{
\item{x}{an object of class \code{spei}.}

\item{...}{additional parameters, not used at present.}

\item{object}{an object of class \code{spei}.}
}
\description{
Generic methods for extracting information and plotting \code{spei} objects.

See print.spei

See print.spei
}
\details{
These functions allow extracting information and plotting
\code{spei} objects. \code{print} yields the fitted values, i.e. a time
series of SPEI or SPI values. \code{summary} reports the function call,
the parameters of the PDF used, and the time series of SPEI or SPI values.
\code{plot} produces a plot of the time series of SPEI or SPI values, with
blue and red colors for positive and negative values, respectively. If a
reference period was used in the function call it is shown by a shaded area.
In the event that NA or Inf values were produced, these are shown by
circles.

See print.spei

See print.spei
}
\examples{
# See examples of use in the help page of the spei() function.

}
\references{
S.M. Vicente-Serrano, S. Beguería, J.I. López-Moreno. 2010. A Multi-scalar
drought index sensitive to global warming: The Standardized Precipitation
Evapotranspiration Index – SPEI. \emph{Journal of Climate} \bold{23}: 1696,
DOI: 10.1175/2009JCLI2909.1.
}
\author{
Santiago Beguería
}
