/*
 * Decompiled with CFR 0.152.
 */
package spotGui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import spotGui.fileIO;

public class tarFuncGenerator {
    private JFrame jFrame = null;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JDialog aboutDialog = null;
    private JPanel aboutContentPane = null;
    private JLabel aboutVersionLabel = null;
    private JTextField functionFormulaTextField = null;
    private JLabel functionLabel = null;
    private JCheckBox noiseCheckBox = null;
    private JTextField noiseTextField = null;
    private JLabel noiseLabel = null;
    private JFileChooser functionFileChooser = null;
    private File pathDefaultFile = new File("");
    private FileFilter fileFilterR = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".r");
        }

        @Override
        public String getDescription() {
            return "R Files(*.r)";
        }
    };
    private FileFilter fileFilterAll = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return !f.getName().isEmpty();
        }

        @Override
        public String getDescription() {
            return "All files (*.*)";
        }
    };
    private JMenuItem saveMenuItem = null;

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setDefaultCloseOperation(3);
            this.jFrame.setResizable(false);
            this.jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/spotGui/icon_tab_algorithm.png")));
            this.jFrame.setJMenuBar(this.getJJMenuBar());
            this.jFrame.setSize(480, 173);
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.setTitle("SPOT GUI Function Generator");
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    switch (e.getID()) {
                        case 201: {
                            int answer = JOptionPane.showConfirmDialog(tarFuncGenerator.this.jFrame, "Unsaved changes will be lost. Are you sure?", "Exit", 0, 3);
                            if (answer == 0) {
                                tarFuncGenerator.this.jFrame.setDefaultCloseOperation(2);
                                break;
                            }
                            tarFuncGenerator.this.jFrame.setDefaultCloseOperation(0);
                            break;
                        }
                    }
                }
            });
        }
        return this.jFrame;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.noiseLabel = new JLabel();
            this.noiseLabel.setBounds(283, 98, 150, 22);
            this.noiseLabel.setEnabled(false);
            this.noiseLabel.setFont(new Font("Dialog", 1, 12));
            this.noiseLabel.setText("default noise amplitude");
            this.functionLabel = new JLabel();
            this.functionLabel.setBounds(6, 8, 460, 50);
            this.functionLabel.setFont(new Font("Dialog", 1, 12));
            this.functionLabel.setText("<html>Enter formula of the target function like this:<br>(x2 - 5.1/(4 * pi^2) * (x1^2) + 5/pi * x1 - 6)^2 + 10 * (1 - 1/(8 * pi)) * cos(x1) + 10<br> </html>");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getFunctionFormulaTextField(), null);
            this.jContentPane.add((Component)this.functionLabel, null);
            this.jContentPane.add((Component)this.getNoiseCheckBox(), null);
            this.jContentPane.add((Component)this.getNoiseTextField(), null);
            this.jContentPane.add((Component)this.noiseLabel, null);
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getSaveMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(tarFuncGenerator.this.jFrame, "Unsaved changes will be lost. Are you sure?", "Exit", 0, 3);
                    if (answer == 0) {
                        tarFuncGenerator.this.jFrame.dispose();
                    } else {
                        tarFuncGenerator.this.jFrame.setDefaultCloseOperation(0);
                    }
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog aboutDialog = tarFuncGenerator.this.getAboutDialog();
                    aboutDialog.pack();
                    Point loc = tarFuncGenerator.this.getJFrame().getLocation();
                    loc.translate(20, 20);
                    aboutDialog.setLocation(loc);
                    aboutDialog.setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new JDialog((Frame)this.getJFrame(), true);
            this.aboutDialog.setTitle("About");
            this.aboutDialog.setSize(new Dimension(295, 171));
            this.aboutDialog.setResizable(false);
            this.aboutDialog.setContentPane(this.getAboutContentPane());
        }
        return this.aboutDialog;
    }

    private JPanel getAboutContentPane() {
        if (this.aboutContentPane == null) {
            this.aboutContentPane = new JPanel();
            this.aboutContentPane.setLayout(new BorderLayout());
            this.aboutContentPane.add((Component)this.getAboutVersionLabel(), "Center");
        }
        return this.aboutContentPane;
    }

    private JLabel getAboutVersionLabel() {
        if (this.aboutVersionLabel == null) {
            this.aboutVersionLabel = new JLabel();
            this.aboutVersionLabel.setText("<html><center>This is a function generator for the SPOT GUI. <br> The parameters of the generated functions <br> can be optimized by SPOT, both by using the <br> GUI or with the command line SPOT call.<br><br>The main purpose is to demonstrate how to <br> build a target function for SPOT, and to easily <br> generate simple test functions.</center></html>");
            this.aboutVersionLabel.setHorizontalAlignment(0);
        }
        return this.aboutVersionLabel;
    }

    private JTextField getFunctionFormulaTextField() {
        if (this.functionFormulaTextField == null) {
            this.functionFormulaTextField = new JTextField();
            this.functionFormulaTextField.setText("x1*x1+x2*x2+x3*x3");
            this.functionFormulaTextField.setBounds(new Rectangle(6, 65, 460, 20));
        }
        return this.functionFormulaTextField;
    }

    private JCheckBox getNoiseCheckBox() {
        if (this.noiseCheckBox == null) {
            this.noiseCheckBox = new JCheckBox();
            this.noiseCheckBox.setFont(new Font("Dialog", 1, 12));
            this.noiseCheckBox.setText("add noise to the Formula ");
            this.noiseCheckBox.setBounds(new Rectangle(9, 94, 172, 31));
            this.noiseCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!tarFuncGenerator.this.noiseTextField.isEnabled()) {
                        tarFuncGenerator.this.noiseTextField.setEnabled(true);
                        tarFuncGenerator.this.noiseLabel.setEnabled(true);
                    } else {
                        tarFuncGenerator.this.noiseTextField.setEnabled(false);
                        tarFuncGenerator.this.noiseLabel.setEnabled(false);
                    }
                }
            });
        }
        return this.noiseCheckBox;
    }

    private JTextField getNoiseTextField() {
        if (this.noiseTextField == null) {
            this.noiseTextField = new JTextField();
            this.noiseTextField.setEnabled(false);
            this.noiseTextField.setBounds(190, 100, 87, 20);
            this.noiseTextField.setText("0");
        }
        return this.noiseTextField;
    }

    private JFileChooser getFunctionFileChooser() {
        if (this.functionFileChooser == null) {
            this.functionFileChooser = new JFileChooser();
            this.functionFileChooser.removeChoosableFileFilter(this.functionFileChooser.getChoosableFileFilters()[0]);
            this.functionFileChooser.addChoosableFileFilter(this.fileFilterAll);
            this.functionFileChooser.addChoosableFileFilter(this.fileFilterR);
        }
        this.functionFileChooser.setCurrentDirectory(this.pathDefaultFile);
        return this.functionFileChooser;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText("Save As .R File");
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, true));
            this.saveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser functionFileFC = tarFuncGenerator.this.getFunctionFileChooser();
                    int ret = functionFileFC.showDialog(tarFuncGenerator.this.saveMenuItem.getParent(), "Save");
                    if (ret == 0) {
                        tarFuncGenerator.this.pathDefaultFile = functionFileFC.getSelectedFile();
                        if (!tarFuncGenerator.this.pathDefaultFile.toString().toLowerCase().endsWith(".r")) {
                            tarFuncGenerator.this.pathDefaultFile = new File(String.valueOf(tarFuncGenerator.this.pathDefaultFile.toString()) + ".r");
                        }
                        int dim = 0;
                        String formula = tarFuncGenerator.this.functionFormulaTextField.getText().toString();
                        int tempDim = 0;
                        int i = 0;
                        while (i < formula.length()) {
                            if (formula.substring(i).contains("x")) {
                                int tempI = formula.substring(i).indexOf("x");
                                int ii = i + tempI + 1;
                                while (ii < formula.length()) {
                                    if (ii == formula.length() - 1) {
                                        tempDim = Integer.valueOf(formula.substring(i + tempI + 1, ii + 1));
                                        break;
                                    }
                                    if (!Character.isDigit(formula.charAt(ii + 1))) {
                                        tempDim = Integer.valueOf(formula.substring(i + tempI + 1, ii + 1));
                                        break;
                                    }
                                    ++ii;
                                }
                                if (tempDim > dim) {
                                    dim = tempDim;
                                }
                                ++i;
                            }
                            ++i;
                        }
                        fileIO.writeTarFunc(tarFuncGenerator.this.pathDefaultFile, formula, dim, tarFuncGenerator.this.noiseCheckBox.isSelected(), tarFuncGenerator.this.noiseTextField.getText().toString());
                    }
                }
            });
        }
        return this.saveMenuItem;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tarFuncGenerator application = new tarFuncGenerator();
                application.getJFrame().setVisible(true);
            }
        });
    }
}

