% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportSeverity.R
\name{getSampleSize}
\alias{getSampleSize}
\title{getSampleSize}
\usage{
getSampleSize(mu0, mu1, alpha, beta, sigma, alternative = "greater")
}
\arguments{
\item{mu0}{mean value of the null hypothesis (usually referred to as H0)}

\item{mu1}{mean value of the alternative hypothesis (usually referred to as H1)}

\item{alpha}{type I error}

\item{beta}{type II error}

\item{sigma}{sample s.d.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided", "greater" (default) or "less".}
}
\value{
n number of required samples in each arm of a trial. Note: total number of samples is 2*n.
}
\description{
Implements sample size calculations in R
See also: \url{https://www.cyclismo.org/tutorial/R/power.html}
and \url{https://influentialpoints.com/Training/statistical_power_and_sample_size.htm}
}
\examples{

getSampleSize(mu0 = 0, mu1 = 200, alpha=0.05, beta=0.2, sigma=450, 
alternative="two.sided")
getSampleSize(mu0 = 8.72, mu1 = 8.72*1.1, alpha=0.05, beta=0.2, sigma=1.3825, 
alternative="greater")
getSampleSize(mu0 = 8.72, mu1 = 8.72*1.1, alpha=0.05, beta=0.2, sigma=1.3825, 
alternative="two.sided")

}
