% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funContinuous.R
\name{funGulf}
\alias{funGulf}
\title{funGulf (No.17, More No. 11)}
\usage{
funGulf(x, m = 99)
}
\arguments{
\item{x}{matrix (n x 3) of points to evaluate with the function. 
Rows for points and columns for dimension.
Values should be larger than 0.}

\item{m}{additional parameter: .
The Gulf function supports an additional parameter m in the range from 3 to 100}
}
\value{
1-column matrix with resulting function values
}
\description{
3-dim Gulf research and development Test Function
}
\examples{
x1 <- matrix(c(50,25,1.5),1,)
funGulf(x1)

funGulf(x1,m=50)

resGulf <- spot(,funGulf,c(0,0,0),c(100,50,5))
resGulf$xbest
resGulf$ybest
plotModel(resGulf$model, which=1:2)
plotModel(resGulf$model, which=2:3)

# x0 is an optional start point (or set of start points), specified as a matrix.
# One row for each point, and one column for each optimized parameter.
x0 = matrix(c(5,2.5,0.15),1,3)
resGulf <- spot(x0,funGulf,c(0,0,0),c(100,50,5))
resGulf$xbest
resGulf$ybest

}
\references{
More, J. J., Garbow, B. S., and  Hillstrom, K. E. (1981).
Testing unconstrained optimization software.
\emph{ACM Transactions on Mathematical Software (TOMS)}, \emph{7}(1), 17-41.
\doi{10.1145/355934.355936}
}
