% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportSeverity.R
\name{plot.spotSeverity}
\alias{plot.spotSeverity}
\title{Plot method for spotSeverity}
\usage{
\method{plot}{spotSeverity}(
  x,
  add = FALSE,
  rangeLeft = -1,
  rangeRight = 1,
  plotSev = TRUE,
  plotPow = FALSE,
  cl = "black",
  xlab = "x",
  ylab = "y",
  ...
)
}
\arguments{
\item{x}{severity object}

\item{add}{default value is FALSE}

\item{rangeLeft}{range default:\code{-1}}

\item{rangeRight}{range default:\code{1}}

\item{plotSev}{logical. plot severity. Default: TRUE}

\item{plotPow}{logical. plot power. Default: FALSE}

\item{cl}{color, e.g.,  \code{c("black", "red", "green", " blue" , "brown", 
"cyan", "darkred", "gray",  "green", "magenta", "orange")}}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{...}{additional parameters}
}
\value{
description of return value
}
\description{
Plot method for spotSeverity
}
\examples{
### Example from D G Mayo and A Spanos. 
### Severe Testing as a Basic Concept in a Neyman–Pearson Philosophy of Induction. 
### British Journal for the Philosophy of Science, 57:323–357, 2006. (fig 2):
x0 <- 12.1
mu1 <- seq(11.9,13,0.01)
n <- 100
sigma <- 2
alpha <- 0.025
tdist <- FALSE
plot(mu1, spotSeverity(xbar=x0, mu0=0, mu1=mu1, n=n, sigma=sigma, alpha=alpha, 
tdist=tdist)$severity, type = "l", ylim=c(0,1), col="blue")
abline(h=0)
abline(h=1)
 abline(h=0.95)
abline(v=12.43)
### plot power:
mu0 <- 12
points(mu1, spotPower(alpha, mu0, mu1, n, sigma), type = "l", ylim=c(0,1), 
col="green")
abline(v=12.72)

## Fig 13.11 in Span19a
p <- spotSeverity(xbar=10, mu0=10, mu1= 10.2, n=100, sigma = 1, alpha = 0.05, tdist = FALSE)
plot(p, rangeLeft = 10, rangeRight = 10.5, plotPow = TRUE)

}
