% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildTree.R
\name{buildTreeModel}
\alias{buildTreeModel}
\title{Tree Regression Interface}
\usage{
buildTreeModel(x, y, control = list())
}
\arguments{
\item{x}{matrix of input parameters. Rows for each point, columns for each parameter.}

\item{y}{one column matrix of observations to be modeled.}

\item{control}{list of control parameters, currently not used.}
}
\value{
an object of class \code{"spotTreeModel"}, with a \code{predict} method and a \code{print} method.
}
\description{
This is a simple wrapper for the rpart function from the rpart package.
The purpose of this function is to provide an interface as required by SPOT, to enable
modeling and model-based optimization with regression trees.
}
\examples{
## Create design points
set.seed(1)
x <- cbind(runif(20)*15-5, runif(20)*15)
## Compute observations at design points (for Branin function)
y <- funBranin(x)
## Create model
fit <- buildTreeModel(x,y)
## Print model parameters
print(fit)
## Predict at new location
predict(fit,cbind(1,2))
## True value at location
funBranin(matrix( c(1,2), 1, ))
## 
set.seed(123)
x <- seq(-1,1,1e-2)
y0 <- c(-10,10)
sfun0  <- stepfun(0, y0, f = 0)
y <- sfun0(x)
fit <- buildTreeModel(x,y)
# plot(fit)
# plot(x,y, type = "l")
yhat <- predict(fit, newdata = 1)
yhat$y == 10

}
