% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimLagp.R
\name{obj.plgpEI}
\alias{obj.plgpEI}
\title{Wrapper for Expected improvement (Gramacy)}
\usage{
obj.plgpEI(x, fmin, gpi, pred = predGPsep)
}
\arguments{
\item{x}{matrix of points to calculate EI}

\item{fmin}{best function value (y) so far}

\item{gpi}{Gaussian process C-side object}

\item{pred}{prediction model. Default: \code{predGPsep}}
}
\value{
negative expected improvement
}
\description{
Wrapper for Expected improvement (Gramacy)
}
\examples{

library(laGP)
library(plgp)

ninit <- 12
dim <- 2
X <- designLHD(,rep(0,dim), rep(1,dim), control=list(size=ninit))
y <- funGoldsteinPrice(X)
m <- which.min(y)
ymin <- y[m]
start <- matrix(X[m,], nrow =1)

## Build laGP model
gpi <- newGPsep(X, y, d=0.1, g=1e-8, dK=TRUE)
da <- darg(list(mle=TRUE, max=0.5), designLHD(,rep(0,dim), rep(1,dim), control=list(size=1000)))
mleGPsep(gpi, param="d", tmin=da$min, tmax=da$max, ab=da$ab)
res <- optim(start[1,], obj.plgpEI, method="L-BFGS-B", lower=0, upper=1, 
gpi=gpi, pred=predGPsep, fmin=ymin)
xnew <- c(res$par, -res$value)
print(xnew)
deleteGPsep(gpi)

}
\seealso{
\code{\link{plgpEI}}.
}
