% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelMarkovChain.R
\name{plotRegion}
\alias{plotRegion}
\title{plotRegion}
\usage{
plotRegion(regionList, countryIndex = 1)
}
\arguments{
\item{regionList}{A list containing a representation of the data.}

\item{countryIndex}{num Index}
}
\value{
A plot
}
\description{
Plot confirmed cases and fatalities (cumulative) for one country/region by index.
}
\details{
Data are taken from the \code{regionTrain} and \code{regionPopulation} data sets
that were combined using the \code{\link{preprocessInputData}} function.
\code{regionTrain} and \code{regionPopulation} are stored in the
\code{babsim.data} package.
}
\examples{
regionList <- preprocessInputData(regionTrain, regionPopulation)
p <- plotRegion(regionList = regionList, countryIndex = 1)

}
\seealso{
\code{\link{plotRegionByName}}.
}
