% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.SPQR.R
\name{summary.SPQR}
\alias{summary.SPQR}
\title{summary method for class \code{SPQR}}
\usage{
\method{summary}{SPQR}(object, ...)
}
\arguments{
\item{object}{An object of class \code{SPQR}.}

\item{...}{Other arguments.}
}
\value{
An object of class \code{summary.SPQR}. A list containing summary information
of the fitted model.
\item{method}{The estimation method}
\item{time}{The elapsed time}
\item{prior}{If \code{method = "MAP"} or \code{method = "MCMC"}, the hyperprior model for the variance hyperparameters}
\item{model}{If \code{method = "MLE"} or \code{method = "MAP"}, the fitted \code{torch} model. If \code{method = "MCMC"}, the posterior samples of neural network parameters}
\item{loss}{If \code{method = "MLE"} or \code{method = "MAP"}, the train and validation loss}
\item{optim.info}{If \code{method = "MLE"} or \code{method = "MAP"}, configuration information of the Adam routine}
\item{elpd}{If \code{method = "MCMC"}, the expected log-predictive density}
\item{diagnostics}{If \code{method = "MCMC"}, diagnostic information of the MCMC chain}
}
\description{
summarizes the output produced by \code{SPQR()} and structures them in a more organized way to be examined by the user.
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)

## summarize output
summary(fit)
}
}
