% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseness_funcs.R
\name{spatial.chaos}
\alias{spatial.chaos}
\title{Spatial chaos measure.}
\usage{
spatial.chaos(im, levels = 30, morph = TRUE)
}
\arguments{
\item{im}{2-D numeric matrix representing the image pixel intensities.}

\item{levels}{numeric (default = 30). Number of histogram bins.}

\item{morph}{logical (default = \code{TRUE}). Whether morphological operations should
be applied to the binary image.}
}
\value{
A value between 0 and 1. A value close to 1 represents a high level of
spatial scatteredness, a value close to 0 represents a less level of spatial
scatteredness. Maximum possible value is 1 - 1 / (# histogram bins)
}
\description{
\code{spatial.chaos} returns the 'spatial chaos' randomness measure for
imaging data.
}
\examples{
## Load package
library("SPUTNIK")

## Image
im <- matrix(rnorm(100), 10, 10)

## Spatial chaos
sc <- spatial.chaos(im, levels = 30, morph = TRUE)
stopifnot(sc <= 1)

## Gini index
gi <- gini.index(im, levels = 16)
stopifnot(gi >= -1 && gi <= 1)

## Scatter ratio
sr <- scatter.ratio(im)
stopifnot(sr <= 1)
}
\references{
Palmer, A., Phapale, P., Chernyavsky, I., Lavigne, R., Fay,
D., Tarasov, A., ... & Becker, M. (2017). FDR-controlled metabolite annotation
for high-resolution imaging mass spectrometry. Nature methods, 14(1), 57.
}
\seealso{
\link{gini.index} \link{scatter.ratio}
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
