#' The health of burros
#' 
#' The health of females burros in the Mojave Desert.
#' 
#' @docType data
#' 
#' @keywords datasets
#' 
#' @format A data frame with 9 rows and 3 columns:
#' \describe{
#'   \item{Status}{The reproductive status of the female burro; one of \code{1} (barren), \code{2} (pregnant (but not lactating)), or \code{3} (lactating)}
#'   \item{Health}{The health of the burro; one of \code{1} (excellent), \code{2} (fair) or \code{3} (poor).}
#'   \item{Counts}{The number of female burros in each cell}
#' }
#' 
#' @details 
#' The data provide the number of female burros of given health 
#' and reproductive status.
#' 
#' @source 
#' Johnson, R. A., Carothers, S. W., & McGill, T. J. (1987). 
#' Demography of feral burros in the Mohave Desert. 
#' \emph{The Journal of Wildlife Management}, \bold{51}(4), 916--920.
#' 
#' @usage 
#' data(Burros)
#' 
#' @examples
#' barplot( xtabs( Counts ~ Status + Health, data = Burros), names.arg = c("Barren", "Pregnant", "Lactating"), ylab = "Number of burros" )
#' 

"Burros"
