% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSRTLocs.R
\name{srtsim_newlocs}
\alias{srtsim_newlocs}
\title{Fit the marginal distributions for each row of a count matrix}
\usage{
srtsim_newlocs(
  simsrt,
  new_loc_num = NULL,
  loc_lay_out = c("grid", "random"),
  voting_nn = 3
)
}
\arguments{
\item{simsrt}{A SRTsim object}

\item{new_loc_num}{A integer specifying the number of spatial locations in the synthetic data}

\item{loc_lay_out}{a character string specifying arrangement of new generated spatial locations. Default is "grid"}

\item{voting_nn}{A integer of nearest neighbors used in label assignment for new generated locations. Default is 3.}
}
\value{
Returns a object with estimated parameters
}
\description{
Fit the marginal distributions for each row of a count matrix
}
\examples{

## Create a simSRT object
toySRT  <- createSRT(count_in=toyData$toyCount,loc_in = toyData$toyInfo)
set.seed(1)

## Create New Locations within Profile
toySRT2  <- srtsim_newlocs(toySRT,new_loc_num=1000)

## Explore New Generated Locations
simcolData(toySRT2)
}
