% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hierarchies2ModelMatrix.R
\name{HierarchyComputeDummy}
\alias{HierarchyComputeDummy}
\title{HierarchyComputeDummy}
\usage{
HierarchyComputeDummy(data, hierarchies, inputInOutput = TRUE,
  crossTable = FALSE, ...)
}
\arguments{
\item{data}{data}

\item{hierarchies}{hierarchies}

\item{crossTable}{Cross table in output when TRUE}

\item{...}{Further parameters sent to \code{\link{HierarchyCompute}}}
}
\value{
A sparse model matrix or a list of model matrix and cross table
}
\description{
From hierarchies to a sparse model matrix with possible cross table by wrapping HierarchyCompute
}
\details{
This function is a special wrapper of \code{\link{HierarchyCompute}} and the input argument hierarchies is specified the same way. 
That is, variables can also be coded by \code{"rowFactor"}  ( but not colFactor).
}
\examples{
# Data and hierarchies used in the examples
x <- SSBtoolsData("sprt_emp")  # Employment in sport in thousand persons from Eurostat database
geoHier <- SSBtoolsData("sprt_emp_geoHier")
ageHier <- SSBtoolsData("sprt_emp_ageHier")
HierarchyComputeDummy(x, list(age = ageHier, geo = geoHier, year = "rowFactor"), 
                      inputInOutput = FALSE, crossTable = TRUE)
}
\author{
Øyvind Langsrud
}
\keyword{internal}
