% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternMatching.R
\name{WildcardGlobbingVector}
\alias{WildcardGlobbingVector}
\title{Selection of elements by wildcard/globbing}
\usage{
WildcardGlobbingVector(x, wg, negSign = "-", invert = "!")
}
\arguments{
\item{x}{Character vector}

\item{wg}{Character vector with wildcard/globbing}

\item{negSign}{Character representing selection to be removed}

\item{invert}{Character to invert each single selection.}
}
\value{
vector with selected elements of x
}
\description{
Selection of elements by wildcard/globbing
}
\examples{
data(precip)
x <- names(precip)

# Select the cities starting with B, C and Sa.
WildcardGlobbingVector(x, c("B*", "C*", "Sa*"))

# Remove from the selection cities with o and t in position 2 and 4, respectively.
WildcardGlobbingVector(x, c("B*", "C*", "Sa*", "-?o*", "-???t*"))

# Add to the selection cities not having six or more letters.
WildcardGlobbingVector(x, c("B*", "C*", "Sa*", "-?o*", "-???t*", "!??????*"))
}
\author{
Øyvind Langsrud
}
