% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_utils.R
\name{formula_term_labels}
\alias{formula_term_labels}
\title{Retrieve term labels from a formula}
\usage{
formula_term_labels(formula, intercept = "(Intercept)")
}
\arguments{
\item{formula}{An R formula, e.g. ~ x1 * x2.}

\item{intercept}{A character string indicating the name for the intercept. The default value is "(Intercept)".
If NULL is provided, the intercept will not be included, even if present in the formula.}
}
\value{
A character vector containing the term labels. If an intercept is present and intercept is not NULL,
the intercept is returned first, followed by the remaining terms.
}
\description{
This function extracts the term labels from the right-hand side of a given R formula.
If an intercept is to be included (and a name for the intercept is provided), it will be added
as the first element of the returned vector.
}
\details{
The default intercept value, "(Intercept)", is chosen to be consistent with the intercept label
returned by functions such as \code{\link[stats:lm]{stats::lm()}}, \code{\link[stats:model.matrix]{stats::model.matrix()}}, and similar modeling functions.
}
\note{
This function is documented by ChatGPT after some discussion.
}
\examples{
# With intercept:
formula_term_labels(~ x1 * x2)

# Without intercept:
formula_term_labels(~ x1 * x2, intercept = NULL)

}
\keyword{internal}
