% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ObjFun_COMP_cpp}
\alias{ObjFun_COMP_cpp}
\title{COMP objective function}
\usage{
ObjFun_COMP_cpp(d, W, residue)
}
\arguments{
\item{d}{is a dictionary element}

\item{W}{is a frequency matrix \eqn{m \times s} with frequency vectors in matrix rows.}

\item{residue}{is a residue vector.}
}
\value{
an objective function value
}
\description{
Computation of the objective function from the Compressive Orthogonal Matching Pursuit algorithm.
}
\details{
The objective function of the Compressive Orthogonal Matching Pursuit is defined as:
\eqn{-\frac{SK(d)\cdot r}{\|SK(d)\|}}, where \eqn{SK(d)} denotes a
sketch of the dictionary element \code{d} and \eqn{r} is the residue vector, which is defined as the difference between
the data sketch \eqn{SK} and the weighted sum of the dictionary elements' sketches, \emph{i.e.}
\eqn{SK - \sum_{i=1}^K \beta_i \cdot SK(d_i)}.
This function is involved in \code{\link{COMP_initialization}} routine.
}
\examples{
X = matrix(abs(rnorm(n = 1000)), ncol = 100, nrow = 10)
X_fbm = bigstatsr::as_FBM(X)$save()
W = chickn::GenerateFrequencies(Data = X_fbm, m = 64, N0 = ncol(X_fbm),
                                ncores = 1, niter= 3, nblocks = 2, sigma_start = 0.001)$W
SK= chickn::Sketch(X_fbm, W)
D = X_fbm[, sample(ncol(X_fbm), 10)]
weights = sample(10, 10)/10
SK_D = rbind(cos(W\%*\%D), sin(W\%*\%D))
d = D[,1]
r = SK - SK_D\%*\%weights
OF = ObjFun_COMP_cpp(d, W, r)
}
\seealso{
\code{\link{COMP_initialization}}, \code{\link{Gradient_COMP_cpp}}
}
