% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stacked.SDM.R
\docType{class}
\name{Stacked.SDM-class}
\alias{Stacked.SDM-class}
\title{An S4 class to represent SSDMs}
\description{
This is an S4 class to represent SSDMs that assembles multiple algorithms
(including generalized linear model, general additive model, multivariate
adaptive splines, generalized boosted regression model, classification tree
analysis, random forest, maximum entropy, artificial neural network, and
support vector machines) built for multiple species. It is obtained with
\code{\link{stack_modelling}} or \code{\link{stacking}}.
}
\section{Slots}{

\describe{
\item{\code{name}}{character. Name of the SSDM (by default 'Species.SSDM').}

\item{\code{diversity.map}}{raster. Local species richness map produced by the SSDM.}

\item{\code{endemism.map}}{raster. Endemism map produced by the SSDM (see Crisp et al
(2011) in references).}

\item{\code{uncertainty}}{raster. Between-algorithm variance map.}

\item{\code{evaluation}}{data frame. Evaluation of the SSDM (AUC, Kappa, omission
rate, sensitivity, specificity, proportion of correctly predicted
occurrences).}

\item{\code{variable.importance}}{data frame. Relative importance of each variable in
the SSDM.}

\item{\code{algorithm.correlation}}{data frame. Between-algorithm correlation matrix.}

\item{\code{enms}}{list. List of ensemble SDMs used in the SSDM.}

\item{\code{parameters}}{data frame. Parameters used to build the SSDM.}

\item{\code{algorithm.evaluation}}{data frame. Evaluation of the algorithm averaging
the metrics of all SDMs (AUC, Kappa, omission rate, sensitivity,
specificity, proportion of correctly predicted occurrences).}
}}

\references{
M. D. Crisp, S. Laffan, H. P. Linder & A. Monro (2001)
 "Endemism in the Australian flora"  \emph{Journal of Biogeography}
 28:183-198
 \url{http://biology-assets.anu.edu.au/hosted_sites/Crisp/pdfs/Crisp2001_endemism.pdf}
}
\seealso{
\linkS4class{Ensemble.SDM} an S4 class to represent ensemble SDMs,
 and \linkS4class{Algorithm.SDM} an S4 class to represent SDMs.
}
