% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSL.R
\name{sslLabelProp}
\alias{sslLabelProp}
\title{Label Propagation}
\usage{
sslLabelProp(x, y, known.label, graph.type = "exp", dist.type = "Euclidean",
  alpha, alpha1, alpha2, k, epsilon, iter = 1000)
}
\arguments{
\item{x}{a n * p matrix or data.frame of n observations and p predictors}

\item{y}{a vector of k known labels. The rows of \code{y} must be
the same as the length of \code{known.label}.}

\item{known.label}{a vector indicating the row index of known labels in matrix \code{x}.}

\item{graph.type}{character string; which type of graph should be created? Options
include \code{knn},\code{enn},\code{tanh} and \code{exp}.
\itemize{\item \code{knn} :kNN graphs.Nodes i, j are connected by an edge if i is in j 's k-nearest-neighborhood. \code{k} is a hyperparameter that controls the density of the graph.
\item \code{enn} :epsilon-NN graphs. Nodes i, j are connected by an edge, if the distance \code{d(i, j ) < epsilon.} The  hyperparameter \code{epsilon} controls neighborhood radius.
\item \code{tanh}:tanh-weighted graphs.  \code{w(i,j) = (tanh(alpha1(d(i,j) - alpha2)) + 1)/2}. where \code{d(i,j)} denotes the distance between point i and j. Hyperparameters \code{alpha1} and \code{alpha2} control the slope and cutoff value respectively.
\item \code{exp} :exp-weighted graphs.\code{w(i,j) = exp(-d(i,j)^2/alpha^2)},where \code{d(i,j)} denotes the distance between point i and j. Hyperparameter \code{alpha} controls the decay rate.}}

\item{dist.type}{character string; this parameter controls the type of distance measurement.(see \code{\link{dist}} or \code{\link{pr_DB}}).}

\item{alpha}{numeric parameter needed when \code{graph.type = exp}}

\item{alpha1}{numeric parameter needed when \code{graph.type = tanh}}

\item{alpha2}{numeric parameter needed when \code{graph.type = tanh}}

\item{k}{integer parameter needed when \code{graph.type = knn }}

\item{epsilon}{numeric parameter needed when \code{graph.type = enn}}

\item{iter}{iteration}
}
\value{
a n * 1 vector indicating the predictions of n observations in C class
}
\description{
\code{sslLabelProp} propagates a few known labels to a large number of unknown labels
according to their proximities to neighboring nodes. It supports many
kinds of distance measurements and graph representations.
}
\details{
\code{sslLabelProp} implements label propagation algorithm in \code{iter} iterations.It
supports many kinds of distance measurements and four types of graph creations.
}
\examples{
data(iris)
x<-iris[,1:4]
#Suppose we know the first twenty observations of each class and we want to propagate
#these labels to unlabeled data.
# 1 setosa, 2 versicolor, 3 virginica
y<-rep(1:3,each =20)
known.label <-c(1:20,51:70,101:120)
f1<-sslLabelProp(x,y,known.label,graph.type="enn",epsilon = 0.5)
f2<-sslLabelProp(x,y,known.label,graph.type="knn",k =10)
f3<-sslLabelProp(x,y,known.label,graph.type="tanh",alpha1=-2,alpha2=1)
f4<-sslLabelProp(x,y,known.label,graph.type="exp",alpha = 1)
}
\author{
Junxiang Wang
}
\references{
Xiaojin Zhu(2005),Semi-Supervised Learning with Graphs
}
\seealso{
\code{\link{dist}}, \code{\link{pr_DB}}
}

