\name{ioptimum}
\alias{ioptimum}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Identification of the Optimal Sampling Effort
}
\description{
The function estimates the sampling effort in which the rate of change for each additional sampling unit can be considered optimal.
}
\usage{
ioptimum(xx, multi.site = TRUE, c1 = 10, c2 = 5, c3 = 2.5)
}

\arguments{
  \item{xx}{
A data frame generated by \code{\link{summary_ssp}}
}
\item{multi.site}{
Logical argument indicating if several sites were simulated
  }
\item{c1}{First cut. By default 10\% improvement for each sample with respect to the highest MultSE. }
\item{c2}{Second cut. By default 5\% improvement for each sample with respect to the highest MultSE. }
\item{c3}{Third cut. By default 2.5\% improvement for each sample with respect to the highest MultSE.}
}
\details{
Sampling efforts between the minimum (i.e. 2) and c1, can be considered the necessary efforts to improve the precision. The number of samples between c1 and c2 reflects the sub-optimal sampling efforts. The number of samples between c2 and c3 indicate the optimal sampling effort. A cost / benefit criterion (e.g. Underwood, 1990) can be used to set the final sample size within this range. The sampling effort beyond c3 would imply a marginal improvement of the MultSE for each increase in sample size, which would result in an unnecessary sampling effort due to redundancy. The relationship between MultSe, sampling effort, and optimal sampling can be visualized with  \code{\link{plot_ssp}}
}
\value{
\item{sample.cut}{
A vector or matrix with the sampling size for each cut point
}
}
\references{
Guerra-Castro, E. J., J. C. Cajas, F. N. Dias Marques Simoes, J. J. Cruz-Motta, and M. Mascaro. (2020). SSP: An R package to estimate sampling effort in studies of ecological communities. bioRxiv:2020.2003.2019.996991.

Underwood, A. J. (1990). Experiments in ecology and management: Their logics, functions and interpretations. Australian Journal of Ecology, 15, 365-389.
}
\author{
Edlin Guerra-Castro (edlinguerra@gmail.com), Juan Carlos Cajas, Juan Jose Cruz-Motta, Nuno Simoes and Maite Mascaro (mmm@ciencias.unam.mx).
}
\note{
The cuts that define the sampling effort as necessary, sub-optimal, optimal or redundant are arbitrary and can be modified according to each research problem. In particular, it is possible that c3 as 2.5\% is not generated because this would be achieved with a sample size larger than the maximum simulated. In this case, the maximum effort generated with \code{\link[SSP]{sampsd}} will be returned with a warning message.
}

\seealso{
\code{\link[SSP]{sampsd}}
}
\examples{
###To speed up the simulation of these examples, the cases, sites and N were set small.

##Single site: micromollusk from Cayo Nuevo (Yucatan, Mexico)
data(micromollusk)

#Estimation of parameters of pilot data
par.mic<-assempar (data = micromollusk,
                    type= "P/A",
                    Sest.method = "average")

#Simulation of 3 data sets, each one with 20 potential sampling units from a single site
sim.mic<-simdata(par.mic, cases= 3, N = 20, sites = 1)

#Sampling and estimation of MultSE for each sample size (few repetitions
#to speed up the example)

sam.mic<-sampsd(dat.sim = sim.mic,
               Par = par.mic,
               transformation = "P/A",
               method = "jaccard",
               n = 10,
               m = 1,
               k = 3)

#Summary of MultSE for each sampling effort
summ.mic<-summary_ssp(results = sam.mic, multi.site = FALSE)

#Cut-off points to identify optimal sampling effort
opt.mic<-ioptimum(xx = summ.mic, multi.site = FALSE)

##Multiple sites: Sponges from Alacranes National Park (Yucatan, Mexico).
data(sponges)

#Estimation of parameters of pilot data
par.spo<-assempar(data = sponges,
                  type= "counts",
                  Sest.method = "average")

#Simulation of 3 data sets, each one with 20 potential sampling units in 3 sites.
sim.spo<-simdata(par.spo, cases= 3, N = 10, sites = 3)

#Sampling and estimation of MultSE for each sampling design (few repetitions
#to speed up the example)

sam.spo<-sampsd(dat.sim = sim.spo,
                Par = par.spo,
                transformation = "square root",
                method = "bray",
                n = 10,
                m = 3,
                k = 3)

#Summary of MultSE for each sampling effort
summ.spo<-summary_ssp(results = sam.spo, multi.site = TRUE)

#Cut-off points to identify optimal sampling effort
opt.spo<-ioptimum(xx = summ.spo, multi.site = TRUE)

}

\keyword{ multivariate	&	Multivariate Techniques }
\keyword{ ecological communities }
\keyword{ numerical ecology }
