.internal.chk.mod.params <-
function( F, H, Q, R, P0=NULL, beta0=NULL, d, n ) {
	if( is.matrix(Q) ) {

		dimQ <- dim(Q) ; if( dimQ[1] != d | dimQ[2] != d ) { print("Q must be d x d where d is width of H") ; return(NULL) } 		
	} else {
		if( length(Q) != 1 & length(Q) != d ) { print( "length of Q must be either 1 or width of H") ; return(NULL) }
		Q <- diag(Q, d)
	}
	if( is.matrix(R) ) {
		dimR <- dim(R) ; if( dimR[1] != n | dimR[2] != n ) { print("R must be n x n where n is height of H") ; return(NULL) } 
	} else {
		if( length(R) != 1 & length(R) != n ) { print( "length of R must be either 1 or height of H" ) ; return(NULL) }
		R <- diag(R, n)
	}
	if( is.matrix(F) ) {
		dimF <- dim(F) ; if( dimF[1] != d | dimF[2] != d ) { print("F must be d x d where d is width of H") ; return(NULL) } 		
	} else {
		if( length(F) != 1 & length(F) != d ) { print( "length of F must be either 1 or width of H") ; return(NULL) }
		F <- diag(F, d)
	}
	if( !is.null(beta0) ) {
		if( length( beta0 ) != 1 & length( beta0 ) != d ) { 
			return( "length of beta0 must be either 1 or width of H" ) 
		} else { 
			if( length( beta0 ) == 1 ) {
				beta0 <- rep( beta0, d ) 
			} else {
				beta0 <- beta0
			}
		}
	}
	if( !is.null(P0) ) {
		if( is.matrix(P0) ) {
			dimP0 <- dim(P0) ; if( dimP0[1] != d | dimP0[2] != d ) { print("P0 must be d x d where d is width of H") ; return(NULL) } 		
		} else {
			if( length(P0) != 1 & length(P0) != d ) { print( "length of P0 must be either 1 or width of H") ; return(NULL) }
			P0 <- diag(P0, d)
		}
	}
	return( list( F=F, H=H, Q=Q, R=R, P0=P0, beta0=beta0 ) )
}

.internal.chk.mod.params.short <-
function( P0, beta0, d, n ) {
	if( !is.null(beta0) ) {
		if( length( beta0 ) != 1 & length( beta0 ) != d ) { 
			return( "length of beta0 must be either 1 or width of H" ) 
		} else { 
			if( length( beta0 ) == 1 ) {
				beta0 <- rep( beta0, d ) 
			} else {
				beta0 <- beta0
			}
		}
	}
	if( !is.null(P0) ) {
		if( is.matrix(P0) ) {
			dimP0 <- dim(P0) ; if( dimP0[1] != d | dimP0[2] != d ) { print("P0 must be d x d where d is width of H") ; return(NULL) } 		
		} else {
			if( length(P0) != 1 & length(P0) != d ) { print( "length of P0 must be either 1 or width of H") ; return(NULL) }
			P0 <- diag(P0, d)
		}
	}
	return( list( P0=P0, beta0=beta0 ) )
}

.Random.seed <-
c(403L, 390L, 501761931L, -229756992L, 2137014820L, 562704288L, 
1242745380L, 945645228L, -1962747144L, -2141553881L, 975499176L, 
985680350L, -713359049L, 1933438638L, 897097473L, 2029658379L, 
-688911978L, 723415190L, 1940268964L, -1872295612L, 1479763878L, 
-685721265L, -1140999958L, -638053437L, 1928014681L, 1126943691L, 
-224847816L, -534885715L, 1270936908L, -1604563214L, 501111923L, 
208627187L, -553585895L, -652277820L, -1668098341L, -1973050530L, 
-1104250017L, 1722729147L, -1044395368L, -21835873L, -795188770L, 
1206927252L, -435378850L, -66611145L, 108994862L, 622623556L, 
1053004057L, -1464287085L, -667741794L, -1633117646L, -946635936L, 
-217162840L, -2059650723L, -1020786339L, 1230091910L, 958089899L, 
1023584197L, 1690711658L, -858136602L, 2053242064L, -697524258L, 
-673785109L, 819160090L, 830407268L, -6184106L, -783470844L, 
-41395983L, 2014288015L, 802758621L, 1774290761L, 1748250454L, 
-1948578126L, -285101958L, -745794758L, -644488144L, -1165130575L, 
-1095745521L, 1477112657L, -1292748617L, 550873229L, -329991437L, 
1052921124L, 1998595989L, -63772865L, -2005330025L, 215594688L, 
800044653L, 1770881753L, -1387236607L, 652060407L, 1338042668L, 
-1341216436L, -794456320L, 328095250L, 2104215638L, -1859152155L, 
1399679087L, 133306318L, 112191563L, 759656755L, 931946227L, 
62525721L, 625030968L, -1009712857L, -1704396074L, -1345874568L, 
-740887909L, -750252966L, -1985833399L, -156854038L, 1867843679L, 
-311407904L, -1053055675L, 1296718880L, -1751897337L, 1196430123L, 
-454044634L, -308849953L, 641948303L, 1483216987L, -1011738763L, 
-244869459L, 372022428L, -436936221L, 2083863757L, -969982060L, 
321602197L, 1643642586L, 428109344L, 1572514744L, -1169079309L, 
941407483L, 639861091L, -1112062177L, -1398906932L, -56717684L, 
-1924703373L, 1919238848L, -2012912839L, 1769068036L, 1708865098L, 
-893080311L, 56141700L, -947798690L, -1329784038L, -866336311L, 
829271479L, 209603533L, 893959390L, 792894324L, 800000178L, -1476302328L, 
-114573392L, 806784575L, -1725563352L, -1540503251L, -2058570195L, 
933044036L, 2131172863L, -1009290121L, -251516807L, 1734804438L, 
-2047728993L, -2092963642L, 855685583L, 158524846L, -1773438663L, 
589503723L, 2011017573L, -1812750856L, 555651889L, -82961154L, 
-1575669977L, -1247449236L, -1557748108L, 613729478L, 1436364158L, 
541874337L, 1203240957L, 2083866165L, 1156799361L, -1634449300L, 
1427723386L, 539567031L, 563683109L, 739570905L, 608387960L, 
-622287748L, 298315159L, 296506010L, -1898556153L, -1992172348L, 
-1754996400L, 7510751L, -1949466236L, -1679179174L, -1713651783L, 
-1615902973L, 1941930399L, 2096251509L, -981453584L, 1905388949L, 
-173352696L, 1381508359L, -1770748664L, -1092780727L, -1280606503L, 
-7755013L, 1422606677L, -602176410L, -147804094L, -835613261L, 
627421139L, 1938165867L, 1395318096L, -153038829L, 31111449L, 
479106356L, 2124491887L, 1976923757L, -346132489L, 609764050L, 
-167576158L, -101909973L, -1310754220L, 1767267645L, 1249474072L, 
459032028L, -1821731932L, 1139315377L, -1405620423L, 752801313L, 
-2055439914L, 186134667L, -116322654L, -1480178180L, 410035322L, 
496295525L, 1137021914L, 165153798L, -1150137526L, -478969464L, 
1831859703L, -1866205178L, -1570446343L, 884128826L, 514962150L, 
-1209007079L, -1254218326L, -1137226518L, 570738471L, 1470661912L, 
731742878L, -2066567008L, -1828329626L, 1493404293L, 859609523L, 
-1943390897L, 211918314L, 109456620L, -1715361018L, 997292750L, 
2067768193L, 4571302L, 1798975350L, -1278912356L, 1294946552L, 
2042051278L, -332106994L, -647019215L, 1293466116L, -1476728565L, 
-1113792621L, 1715677873L, 872965895L, -30531289L, -1034254777L, 
-1257965630L, 445564127L, 1672852929L, -1258672822L, -1956330246L, 
1648558944L, -228703219L, 1734900744L, -100212967L, 1164136435L, 
486520839L, -1401807372L, -92509998L, 1755265890L, -1669868961L, 
-1716449354L, 1869987701L, -1107926082L, 176884908L, 402378277L, 
2040189545L, 1457342407L, 1055551245L, -259327010L, 1532120580L, 
1881378961L, 1252176058L, -1433320922L, 1527984080L, -319267242L, 
-893034893L, -1559925673L, -717362913L, 1074116942L, 631495531L, 
1012936419L, 107839633L, 815459394L, -2079981327L, 1051675396L, 
-1259804421L, -658764176L, 1826085450L, 1102483234L, 1790205064L, 
2056839235L, -1882493584L, 1496581028L, -1944880371L, 711547373L, 
1314036268L, -1753157804L, -2142176603L, -379938747L, 1410713200L, 
-776401939L, -206106129L, 1057387731L, 2142049154L, 138481085L, 
-2144808110L, -1810575718L, -1641095957L, -1142665103L, -2016079777L, 
-1578178009L, -2056071029L, -181161407L, 1000381848L, 79288372L, 
1115332474L, -728525330L, -72809180L, -1497071278L, -125273L, 
-682828582L, -73784677L, -1481033634L, -665087474L, -1408296505L, 
1851779271L, -2097635126L, 1979736691L, -893541707L, -1866170032L, 
-1045836676L, 223887696L, -1453094066L, 1913679221L, 903858545L, 
1319105752L, 1987413869L, 1133386531L, -902911548L, -2042657236L, 
639202948L, 1010167229L, -137398689L, -1192450406L, 1429082604L, 
-894687169L, -1835337048L, -150756724L, -1415012288L, -1800061007L, 
-1619789745L, 65590824L, -65607561L, -2052114607L, 96282566L, 
1444272111L, 1356122356L, 177359069L, 1753447637L, -1303156159L, 
-1024981312L, 929030259L, 1008293005L, 427370676L, -11256306L, 
30633980L, 546646413L, 520944238L, 1578260713L, -74613258L, -1320794912L, 
-170886273L, -1416497805L, -1009898594L, 656647106L, 1988442L, 
997844246L, -172299103L, -1495844583L, 313163743L, 502754705L, 
-1702586071L, -1469011241L, 16180498L, -961891229L, -1367818619L, 
1539249554L, 1323797089L, 2012237864L, 956166197L, -102525927L, 
-22575483L, 1153672764L, -53780268L, -738781149L, 815915166L, 
1502768593L, -1051814820L, -777522187L, 232764494L, -1749522506L, 
-2003692764L, 108040559L, -993968966L, 523683824L, -2002851274L, 
-1807570201L, -692353734L, -648614190L, 1763955301L, 84617392L, 
-590071435L, 1666724389L, 1729998761L, 7497285L, -1221150171L, 
1263175140L, -1087541829L, 1463364844L, -1639857891L, -1905786427L, 
1470148423L, 1258175466L, -948927963L, -1543578208L, 1614687079L, 
-759736597L, 1187569774L, -671695411L, 1399944619L, -383095423L, 
-821371636L, -955314134L, -506826491L, 1012128731L, -358976381L, 
58724004L, 1467260504L, -375454310L, 978461163L, -549443659L, 
-340090284L, 1290922787L, -1319671368L, 264391774L, 670546041L, 
1267721197L, 1801462017L, -474798615L, -756234336L, -1720734749L, 
182196062L, 1922112415L, -333566330L, 1003287977L, -1166165087L, 
-670320974L, 746030565L, 1946055939L, -394006257L, 1000664169L, 
-1913262772L, 572169934L, -2116676940L, 1312436534L, 633823060L, 
891644536L, 512933068L, -1439922579L, 35985495L, 1029476849L, 
228081140L, -50510002L, -1169357798L, 1021894534L, 717022787L, 
-1484435818L, -484308905L, 1684090831L, -2051289441L, -462985927L, 
-1793776510L, -1030970954L, -765745854L, -2090283915L, -609879L, 
464145726L, 1295030624L, -1251820390L, 1337444493L, 1656327773L, 
-1634964324L, 1929384360L, -1621005570L, -1339884930L, -424477587L, 
376707284L, 1282578302L, -1334057870L, 357813289L, 1152705313L, 
-2106643461L, 2091388426L, 1894110021L, -1497530299L, 566818792L, 
1980784130L, -1957233332L, 150522746L, -1721285255L, -573383672L, 
1512999790L, 664727625L, -845576689L, -453416014L, -807812352L, 
-1741596532L, -1736256908L, -1259286962L, 657135043L, 1028512586L, 
802511160L, -1620439192L, 1343010717L, 1507044580L, -2062168818L, 
1474530290L, 1220813521L, 279151859L, -1833897963L, -364392835L, 
828946423L, -332948392L, -1484854853L, -438960948L, -611125067L, 
-1723676797L, 1896649243L, -1823690548L, 1539107771L, -1997104455L, 
1250441770L, 349239127L, -14802343L, 1953966702L, -1902992230L, 
-1917072569L, -1836288933L, -891652220L, -798422531L, -1447798934L, 
1513935463L, -2070861577L, 1446010078L, -2059090524L, 1709961762L, 
1735689122L, -625569216L, -1564382804L, 637273568L, -158053306L, 
-1405875770L, 1823373630L, 961800200L, -653237811L, -202315386L, 
-2584256L, -25811278L, -2008601138L, -1232531919L, -1368614036L, 
1854755488L, 1852645620L, -1513944942L, -1592685589L, 318043833L, 
-54204285L, 1504140855L, 721053407L, -876147052L, -2132004680L, 
-580154705L, -265360196L, -1611015547L, 1090095811L, 761653091L, 
-1422270472L, 575573422L, 575085180L, -75875188L, 1491972223L, 
13879782L, 102761147L, -1217807721L)
