% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stb.R
\name{SASquantile}
\alias{SASquantile}
\title{Implements SAS-quantile Calculation (PCTLDEF=5) as Described by SAS-Help.}
\usage{
SASquantile(x, prob, tol = 1e-12, type = c("R", "C"))
}
\arguments{
\item{x}{(numeric) vector}

\item{prob}{(numeric) value 0 < prob < 1}

\item{tol}{(numeric) value used for checking numerical equivalence}

\item{type}{(character) "R" = uses the R-implementation, "C" = calls the C-implementation
n}
}
\description{
This implementation seems to be identical with 'type=2' in function \code{\link{quantile}}
but less efficiently implemented, i.e. for large vectors x it is much slower than the built-in
quantile-function.
}
\examples{
\dontrun{
SASquantile(1:100, .75)

### compare to R-default
quantile(1:100, .75) 

### or to what R calls SAS-definition
quantile(1:100, .75, type=3)

# should work for any vector (no seed)
v <- rnorm(50000,20,7)
Q.R2    <- quantile(v, probs=c(.01, .025, .05, .1, .25, .5, .75, .9, .95, .975, .99), type=2)
Q.SAS.R <- SASquantile(v, prob=c(.01, .025, .05, .1, .25, .5, .75, .9, .95, .975, .99), type="R")
Q.SAS.C <- SASquantile(v, prob=c(.01, .025, .05, .1, .25, .5, .75, .9, .95, .975, .99), type="C")

Q.R2
Q.SAS.R
Q.SAS.C
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}

