\name{plotSTEPCAM}
\alias{plotSTEPCAM}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Plot the output generated by the STEPCAM_ABC function
}
\description{
  This function plots the posterior distribution inferred by the STEPCAM_ABC function for the three community assembly parameters stochasticity (i.e. random removal),
  filtering and competition (i.e. limiting similarity). 
}
\usage{
plotSTEPCAM(output)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{output}{The list generated by the function STEPCAM_ABC as output, this list contains the following elements: \cr
            - \code{Stoch}{ a vector containing the posterior distribution for the parameter stochasticity or random removal} \cr
            - \code{Filt}{ a vector containing the posterior distribution for the parameter filtering} \cr
            - \code{Comp}{ a vector containing the posterior distribution for the parameter competition or limiting similarity} \cr
     }
}

\author{Thijs Janzen}

\examples{
Artificial.Data <- generate.Artificial.Data(numSpecies=40,numTraits=3,numCommunities=5,
                   occurence_distribution=0.2,average_richness=0.5,SD_richness=0.2,
                   random.Mechanism=FALSE);
O <- STEPCAM_ABC(Artificial.Data$abundances,Artificial.Data$traits,
                 numParticles=10,n_traits=3,plot_number=1,stopRate=0.8);
plotSTEPCAM(O);
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
