% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemes-S3.R
\name{plot.STMr_scheme}
\alias{plot.STMr_scheme}
\title{Plotting of the Set and Reps Scheme}
\usage{
\method{plot}{STMr_scheme}(x, type = "bar", font_size = 14, perc_str = "\%", ...)
}
\arguments{
\item{x}{\code{STMr_scheme} object. See examples}

\item{type}{Type of plot. Options are "bar" (default), "vertical", and "fraction"}

\item{font_size}{Numeric. Default is 14}

\item{perc_str}{Percent string. Default is "\%". Use "" to have more space on graph}

\item{...}{Forwarded to \code{\link[ggfittext]{geom_bar_text}} and
\code{\link[ggfittext]{geom_fit_text}} functions. Can be used to se the highest
labels size, for example, using \code{size=5}. See documentation for these two
packages for more info}
}
\value{
\code{ggplot2} object
}
\description{
Functions for creating \code{ggplot2} plot of the Set and Reps Scheme
}
\examples{
scheme <- scheme_wave(
  reps = c(10, 8, 6, 10, 8, 6),
  # Adjusting sets to use lower \%1RM (RIR Inc method used, so RIR adjusted)
  adjustment = c(4, 2, 0, 6, 4, 2),
  vertical_planning = vertical_linear,
  vertical_planning_control = list(reps_change = c(0, -2, -4)),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)

plot(scheme)
plot(scheme, type = "vertical")
plot(scheme, type = "fraction")
}
