\name{GenAlgForSubsetSelection}
\alias{GenAlgForSubsetSelection}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Genetic algorithm for subset selection}
\description{
It uses a genetic algorithm to select \eqn{n_{Train}} individuals so that optimality criterion is minimum.
}

\usage{
GenAlgForSubsetSelection(P, Candidates, Test, ntoselect, 
npop, nelite, mutprob,  mutintensity, niterations, lambda,
plotiters=TRUE,errorstat="PEVMEAN",C=NULL, mc.cores=1, InitPop=NULL, 
tolconv=1e-5, Vg=NULL, Ve=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{P}{
\eqn{n \times k} matrix of the first PCs of the predictor variables. The matrix needs to have union of the identifiers of the candidate and test individuals as rownames. For methods using the relationships, P is the inverse of the relationship matrix with row and column names.
}
  \item{Candidates}{ 
  vector of identifiers for the individuals in the candidate set.
}
  \item{Test}{
  vector of identifiers for the individuals in the test set.
}
  \item{ntoselect}{
 \eqn{n_{Train}:} number of individuals to select in the training set.
}
  \item{npop}{
 genetic algorithm parameter, number of solutions at each iteration
}
  \item{nelite}{
 genetic algorithm parameter, number of solutions selected as elite parents which will  generate the next set of solutions. 
}
  \item{mutprob}{
 genetic algorithm parameter, probability of mutation for each generated solution.
}
 \item{mutintensity}{
mean of the poisson variable that is used to decide the number of mutations for each cross. 
}
  \item{niterations}{
 genetic algorithm parameter, number of iterations.  
}

  \item{lambda}{
 scalar shrinkage parameter  (\eqn{\lambda>0}).
}
\item{plotiters}{
 plot the convergence: TRUE or FALSE. Default is TRUE.
}

\item{errorstat}{
 optimality criterion: One of the optimality criterion. Default is "PEVMEAN". It is possible to use user defined functions as shown in the examples.
}

\item{mc.cores}{
 number of cores to use.
}
\item{InitPop}{
a list of initial solutions
}
\item{tolconv}{
if the algorithm cannot improve the errorstat more than tolconv for the last 200 iterations it will stop.
}
 \item{C}{
Contrast Matrix.
}
\item{Vg}{
covariance matrix between traits generated by the relationship K (only for multi-trait version of PEVMEANMM).
}
 \item{Ve}{
residual covariance matrix for the traits (only for multi-trait version of PEVMEANMM). 
}
}

\value{
A list of length nelite+1. The first nelite elements of the list are optimized training samples of size \eqn{n_{train}} and they are listed in increasing order of the optimization criterion. The last item on the list is a vector that stores the minimum values of the objective function at each iteration. 
}

\author{
Deniz Akdemir
}
\note{
The GA does not guarantee convergence to globally optimal solutions and it is highly recommended that the algorithm is replicated to obtain ''good'' training samples. 
}


\examples{
data(iris)
#We will try to estimate petal width from 
#variables sepal length and width and petal length. 
y<-iris[,4]
X<-as.matrix(iris[,1:3])
names(y)<-rownames(X)<-paste(iris[,5], rep(1:50,3),sep='_')

#test data 25 iris plants selected at random from the virginica family, 
#candidates are the plants in the  setosa and versicolor families.
candidates<-rownames(X)[1:100]
test<-sample(setdiff(rownames(X),candidates), 25)
###test sample
ytest<-y[names(y)\%in\%test]
Xtest<-X[rownames(X)\%in\%test,]

#NOTE: Increase niterations and npop substantially for better convergence.

ListTrain<-GenAlgForSubsetSelection(P=X,Candidates=candidates,Test=test,ntoselect=25, 
npop=100, nelite=5, mutprob=.8, niterations=20, lambda=1e-5,
plotiters=FALSE,errorstat="PEVMEAN")


##predictions by optimized sample
ytrainopt<-y[names(y)\%in\% ListTrain[[1]]]
Xtrainopt<-X[rownames(X)\%in\%ListTrain[[1]],]

modelopt<-lm(ytrainopt~1+Xtrainopt)
predictopt<-cbind(rep(1, nrow(Xtest)),Xtest)\%*\%modelopt$coefficients

###predictions by a random sample of the same size
rs<-sample(candidates, 25)
ytrainrs<-y[names(y)\%in\%rs]
Xtrainrs<-X[rownames(X)\%in\%rs,]
modelrs<-lm(ytrainrs~1+Xtrainrs)
predictrs<-cbind(rep(1, nrow(Xtest)),Xtest)\%*\%modelrs$coefficients

#accuracies of the optimized sample and random sample. 
cor(predictopt,ytest)
cor(predictrs, ytest)

 \dontrun{
data(iris)
#We will try to estimate petal width from
#variables sepal length and width and petal length.
y<-iris[,4]
X<-as.matrix(iris[,1:3])
X<-cbind(rep(1,nrow(X)),X)
names(y)<-rownames(X)<-paste(iris[,5], rep(1:50,3),sep="_" )
#test data 25 iris plants selected at random from the virginica family,
#candidates are the plants in the  setosa and versicolor families.
candidates<-rownames(X)[1:100]
test<-sample(setdiff(rownames(X),candidates), 25)
###test sample
ytest<-y[names(y)\%in\%test]
Xtest<-X[rownames(X)\%in\%test,]
#NOTE: Increase niterations and npop substantially for better convergence.
ListTrain2<-GenAlgForSubsetSelection(P=X,Candidates=candidates,
Test=test,ntoselect=25,npop=100,
nelite=5, mutprob=.8, niterations=200,
lambda=1e-5, errorstat="PEVMEAN2")

ListTrain<-GenAlgForSubsetSelection(P=X,Candidates=candidates,
Test=test,ntoselect=25,npop=100,
nelite=5, mutprob=.8, niterations=200, lambda=1e-5, errorstat="PEVMEAN")




##predictions by optimized sample
ytrainopt<-y[names(y)\%in\% ListTrain[[1]]]
Xtrainopt<-X[rownames(X)\%in\%ListTrain[[1]],]
modelopt<-lm(ytrainopt~-1+Xtrainopt)
predictopt<-Xtest\%*\%modelopt$coefficients

ytrainopt2<-y[names(y)\%in\% ListTrain2[[1]]]
Xtrainopt2<-X[rownames(X)\%in\%ListTrain2[[1]],]
modelopt2<-lm(ytrainopt2~-1+Xtrainopt2)
predictopt2<-Xtest\%*\%modelopt2$coefficients


###predictions by a random sample of the same size
rs<-sample(candidates, 25)
ytrainrs<-y[names(y)\%in\%rs]
Xtrainrs<-X[rownames(X)\%in\%rs,]
modelrs<-lm(ytrainrs~-1+Xtrainrs)
predictrs<-Xtest\%*\%modelrs$coefficients
#accuracies of the optimized sample and random sample.


cor(predictopt,ytest)
cor(predictopt2,ytest)


cor(predictrs, ytest)

################based on relationships
Kiris<-cov(t(iris[,1:3]))
Kiris<-Kiris/mean(diag(Kiris))+.001*diag(nrow(Kiris))
rownames(Kiris)<-colnames(Kiris)<-rownames(X)
ListTrain<-GenAlgForSubsetSelection(P=solve(Kiris),Candidates=candidates,Test=test,ntoselect=25, 
                                    npop=100, nelite=5, mutprob=.8, niterations=100, lambda=1,
                                    plotiters=TRUE,errorstat="PEVMEANMM", mc.cores=1)
                                    
                                    
##############use of user defined objective functions   
STPGAUSERFUNC<-function(Train,Test, P, lambda=1e-5,C=NULL, q=1){
  PTrain<-P[rownames(P)\%in\%Train,]
  PTest<-P[rownames(P)\%in\%Test,]
  if (!is.null(C)){PTest<-C\%*\%PTest}
  
  svdD<-svd(PTest\%*\%solve(crossprod(PTrain)+lambda*diag(ncol(P)),t(PTest)), nu=1,nv=1)
  return((prod(svdD$d[1:ncol(P)]^q))^(1/(q*ncol(P))))
}


STPGAUSERFUNC2<-function(Train,Test, P, lambda=1e-5,C=NULL,q=1){
  ####Kiefer's-q q in (-Inf, 1]
  PTrain<-P[rownames(P)\%in\%Train,]
  PTest<-P[rownames(P)\%in\%Test,]
  if (!is.null(C)){PTest<-C\%*\%PTest}
  svdD<-svd(PTest\%*\%solve(crossprod(PTrain)+lambda*diag(ncol(P)),t(PTest)), nu=1,nv=1)
  return(-(mean(1/svdD$d[1:ncol(P)]^q))^(1/(q)))
}


ListTrain<-GenAlgForSubsetSelection(P=X,Candidates=candidates,Test=test,ntoselect=25, 
                                    npop=100, nelite=5, mutprob=.8, niterations=100, lambda=1,
                                    plotiters=TRUE,errorstat="STPGAUSERFUNC", mc.cores=1)


ListTrain2<-GenAlgForSubsetSelection(P=X,Candidates=candidates,Test=test,ntoselect=25, 
                                    npop=100, nelite=5, mutprob=.8, niterations=100, lambda=1,
                                    plotiters=TRUE,errorstat="STPGAUSERFUNC2", mc.cores=1)


}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.

