/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public final class LazilyLoadedCtor {
    private static Method getter;
    private static Method setter;
    private String ctorName;
    private String className;
    private boolean sealed;
    private boolean isReplaced;

    public LazilyLoadedCtor(ScriptableObject scope, String ctorName, String className, boolean sealed) {
        this.className = className;
        this.ctorName = ctorName;
        this.sealed = sealed;
        if (getter == null) {
            Method[] all = FunctionObject.getMethodList(this.getClass());
            getter = FunctionObject.findMethods(all, "getProperty")[0];
            setter = FunctionObject.findMethods(all, "setProperty")[0];
        }
        try {
            scope.defineProperty(ctorName, this, getter, setter, 2);
        }
        catch (PropertyException e) {
            throw WrappedException.wrapException(e);
        }
    }

    public Object getProperty(ScriptableObject obj) {
        ScriptableObject scriptableObject = obj;
        synchronized (scriptableObject) {
            if (!this.isReplaced) {
                boolean removeOnError = false;
                Class<?> cl = null;
                try {
                    cl = Class.forName(this.className);
                }
                catch (ClassNotFoundException ex) {
                    removeOnError = true;
                }
                catch (SecurityException ex) {
                    removeOnError = true;
                }
                if (cl != null) {
                    try {
                        ScriptableObject.defineClass(obj, cl, this.sealed);
                        this.isReplaced = true;
                    }
                    catch (InstantiationException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (ClassDefinitionException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (PropertyException e) {
                        throw WrappedException.wrapException(e);
                    }
                    catch (SecurityException ex) {
                        removeOnError = true;
                    }
                }
                if (removeOnError) {
                    obj.delete(this.ctorName);
                    Object object = Scriptable.NOT_FOUND;
                    return object;
                }
            }
        }
        return obj.get(this.ctorName, (Scriptable)obj);
    }

    public Object setProperty(ScriptableObject obj, Object val) {
        ScriptableObject scriptableObject = obj;
        synchronized (scriptableObject) {
            this.isReplaced = true;
            Object object = val;
            return object;
        }
    }
}

