% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal_dot.R
\name{seasonal_dot}
\alias{seasonal_dot}
\alias{seasonal_dot.swmpr}
\title{Seasonal Dot Plot}
\usage{
seasonal_dot(swmpr_in, ...)

\method{seasonal_dot}{swmpr}(swmpr_in, param = NULL, lm_trend = FALSE,
  lm_lab = FALSE, log_trans = FALSE, converted = FALSE,
  plot_title = FALSE, plot = TRUE, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods. See \code{\link{assign_season}}}

\item{param}{chr string of variable to plot}

\item{lm_trend}{logical, add linear trend line?}

\item{lm_lab}{logical, add significance label? Statistically significant results will appear in bold.}

\item{log_trans}{logical, should y-axis be log? Defaults to \code{FALSE}}

\item{converted}{logical, were the units converted from the original units used by CDMO? Defaults to \code{FALSE}. See \code{y_labeler} for details.}

\item{plot_title}{logical, should the station name be included as the plot title? Defaults to \code{FALSE}}

\item{plot}{logical, should a plot be returned? Defaults to \code{TRUE}}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot average/min/max seasonal values faceted by season
}
\details{
This function summarizes minimum, mean, and maximum values calculated on a seasonal basis to allow for easier intra-season comparisons over time.

\code{lm_trend = T} adds a linear regression to the plot, and \code{lm_lab = T} will add p-values from the linear regression to the plot. If the p-values are significant (p < 0.05) then the text will appear in bold. \code{lm_lab} text is color coded to match with the corresponding dots.
}
\examples{
dat_wq <- elksmwq
#dat_wq <- subset(dat_wq, subset = c('2010-01-01 0:00', '2017-01-01 0:00'))
dat_wq <- qaqc(dat_wq, qaqc_keep = c(0, 3, 5))

x <-
  seasonal_dot(dat_wq, param = 'do_mgl'
               , lm_trend = TRUE
               , lm_lab = TRUE
               , plot_title = TRUE)

\dontrun{
x <-
  seasonal_dot(dat_wq, param = 'do_mgl'
               , lm_trend = FALSE
               , lm_lab = FALSE
               , plot_title = TRUE)

x <-
  seasonal_dot(dat_wq, param = 'do_mgl'
               , lm_trend = TRUE
               , lm_lab = FALSE
               , plot_title = TRUE)


dat_nut <- elknmnut
dat_nut <- subset(dat_nut, subset = c('2007-01-01 0:00', '2017-01-01 0:00'))
dat_nut <- qaqc(dat_nut, qaqc_keep = c(0, 3, 5))

x <-
  seasonal_dot(dat_nut
               , param = 'chla_n'
               , season_grps = list(c(1,2,3), c(4,5,6), c(7,8,9), c(10, 11, 12))
               , season_names = c('Winter', 'Spring', 'Summer', 'Fall')
               , season_start = 'Spring'
               , lm_trend = FALSE
               , lm_lab = FALSE
               , plot_title = TRUE)

x <-
  seasonal_dot(dat_nut, param = 'chla_n'
               , lm_trend = TRUE
               , lm_lab = FALSE
               , plot_title = TRUE)

x <-
  seasonal_dot(dat_nut, param = 'chla_n'
               , lm_trend = TRUE
               , lm_lab = TRUE
               , plot_title = TRUE)
}
}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link{assign_season}}, \code{\link{y_labeler}}
}
\author{
Julie Padilla
}
\concept{
analyze

analyze
}
