% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_sk_national_ft_results.R
\name{create_sk_national_ft_results}
\alias{create_sk_national_ft_results}
\title{Create a Flextable Object of Seasonal Kendall Results}
\usage{
create_sk_national_ft_results(sk_result, param, font_sz_result = 12,
  font_sz_head = 8, ht_head = 0.375, ht_body = 0.2)
}
\arguments{
\item{sk_result}{a \code{data.frame} of reformatted results generated by ntional Level template scripts from reserve level handoff files}

\item{param}{chr, the name of the parameter that corresponds to the seasonal kendall results in \code{sk_result}}

\item{font_sz_result}{int, specify the font size of the displayed results}

\item{font_sz_head}{int, specify the font size of the table header row}

\item{ht_head}{num, specify the cell height of the table body rows. Units for this parameter are in inches.}

\item{ht_body}{num, specify the cell height of the table header row. Units for this parameter are in inches.}
}
\value{
Returns a \code{\link[flextable]{flextable}} object
}
\description{
Create a flextable object to display Seasonal Kendall results for each reserve in the NERRS national level template
}
\details{
This function is intended for internal use with the NERRS national level reporting scripts. Using results from the reserve level trend analyses, \code{create_sk_national_ft_results} creates  a \code{flextable} object of seasonal kendall results to be displayed in the NERRS national level template.
}
\author{
Julie Padilla
}
\concept{
Reporting
}
