% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_seasonal.R
\name{sk_seasonal}
\alias{sk_seasonal}
\alias{sk_seasonal.swmpr}
\title{Seasonal Kendall Analysis for Seasonal Data}
\usage{
sk_seasonal(swmpr_in, ...)

\method{sk_seasonal}{swmpr}(
  swmpr_in,
  param = NULL,
  alpha = 0.05,
  data_min = 5,
  envStats_summary = FALSE,
  stat_lab = "Average",
  FUN = function(x) mean(x, na.rm = TRUE),
  ...
)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods. See \code{\link{assign_season}}}

\item{param}{chr string of variable to plot}

\item{alpha}{num, alpha value to use to significance test. Defaults to 0.05.}

\item{data_min}{num, the minimum number of observations required to perform the analysis. Defaults to 5}

\item{envStats_summary}{logical, should the standard \code{EnvStats::kendallSeasonalTrendTest} be returned? Defaults to \code{FALSE}. See Details for more information.}

\item{stat_lab}{chr, label for the summary statistic defined in \code{FUN}. Defaults to "Average".}

\item{FUN}{function used to aggregate seasonal SWMP data.}
}
\value{
Returns a \code{data.frame} object or a summary from \code{EnvStats::kendallSeasonalTrendTest}
}
\description{
Non-parametric test for monotonic seasonal trends
}
\details{
This function performs a seasonal kendall test on seasonally aggregated values using \code{\link[EnvStats]{kendallSeasonalTrendTest}}.

Data are aggregated on a user-specified seasonal basis using the \code{FUN} argument. For example, using default settings, \code{sk_seasonal} would perform a seasonal kendall test on average monthly values. However, if the user set \code{FUN = min(x, na.rm = TRUE)} then a seasonal kendall would be performed on monthly minimum values.


If \code{EnvStats_summary = TRUE} then the detailed output summary from \code{\link[EnvStats]{kendallSeasonalTrendTest}} will be returned. If \code{EnvStats_summary = FALSE} then an abbreviated summary will be returned in a \code{data.frame}. The abbreviated summary contains the station name, the type of statistic used to summarize the data on a seasonal basis (specified by \code{stat_lab}), and the following results from \code{\link[EnvStats]{kendallSeasonalTrendTest}}: tau, slope, p-value for the chi-square test, and the p-value for the trend test.
}
\examples{
dat_wq <- elksmwq
dat_wq <- qaqc(dat_wq, qaqc_keep = c(0, 3, 5))

x <- sk_seasonal(dat_wq, param = 'temp')

}
\seealso{
\code{\link{assign_season}}, \code{\link{y_labeler}}, \code{\link[EnvStats]{kendallSeasonalTrendTest}}
}
\author{
Julie Padilla
}
\concept{analyze}
