% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_votes.R
\name{readHil}
\alias{readHil}
\title{read a set of ballots in .HIL format}
\usage{
readHil(filnm, quiet = FALSE)
}
\arguments{
\item{filnm}{name of a file in .HIL format}

\item{quiet}{suppress diagnostic output}
}
\value{
a matrix with one row per ballot, one column per candidate, with
named rows and columns, and with attributes "nseats" and "ename"
}
\description{
\href{https://rangevoting.org/TidemanData.html}{rangevoting.org/TidemanData.html}:
The data are in a format developed by David Hill. The first line contains the
number of candidates and the number to be elected. (Many but not all
elections were multi-winner.) In subsequent lines that represent ballot
papers, the first number is always 1. (The format was designed for a counting
program that treats the first number as the number of instances of the
ordering of the candidates on the line.) Next on these lines is a sequence of
numbers representing a voter's reported ranking: The number of the candidate
ranked first, the number of the candidate ranked second, and so on. The end
of the reported ranking is signaled by a zero. A zero at the beginning of the
ranking is a signal that the list of ballot papers has ended. Next come the
names of the candidates, each in parentheses, as required by the counting
program, and finally the name of the election.
}
