## ----setup, include=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
options(width = 999)
knitr::opts_chunk$set(echo = TRUE, fig.width=6, fig.height=4)

## ---- eval = FALSE, echo=TRUE, message=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(sp)
#  # locations (155 observed points)
#  data("meuse")
#  # grid of points (3103)
#  data("meuse.grid")
#  meuse.grid$id <- c(1:nrow(meuse.grid))
#  coordinates(meuse)<-c("x","y")
#  coordinates(meuse.grid)<-c("x","y")
#  lm_lead <- lm(log(lead) ~ dist,data=meuse)
#  lm_zinc <- lm(log(zinc) ~ dist,data=meuse)

## ---- eval = FALSE, echo=FALSE, include=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  par(mfrow=c(1,2))
#  plot(meuse.grid)
#  title("Meuse territory (3103 points)",sub="with reported distance from the river",cex.main=0.8,cex.sub=0.8)
#  plot(meuse)
#  title("Subset of 155 points",sub="with also observed metals concentration",cex.main=0.8,cex.sub=0.8)
#  par(mfrow=c(1,1))

## ---- eval = FALSE,echo=TRUE,message=FALSE,fig.width=6,fig.height=8------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(automap)
#  kriging_lead = autoKrige(log(lead) ~ dist, meuse, meuse.grid)
#  plot(kriging_lead,sp.layout = NULL, justPosition = TRUE)

## ---- eval = FALSE,echo=TRUE,message=FALSE,fig.width=6,fig.height=8------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  kriging_zinc = autoKrige(log(zinc) ~ dist, meuse, meuse.grid)
#  plot(kriging_zinc, sp.layout = list(pts = list("sp.points", meuse)))

## ---- eval = FALSE,echo=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  df <- NULL
#  df$id <- meuse.grid$id
#  df$lead.pred <- kriging_lead$krige_output@data$var1.pred
#  df$lead.var <- kriging_lead$krige_output@data$var1.var
#  df$zinc.pred <- kriging_zinc$krige_output@data$var1.pred
#  df$zinc.var <- kriging_zinc$krige_output@data$var1.var
#  df$lon <- meuse.grid$x
#  df$lat <- meuse.grid$y
#  df$dom1 <- 1
#  df <- as.data.frame(df)
#  head(df)
#  #   id lead.pred  lead.var zinc.pred  zinc.var    lon    lat dom1
#  # 1  1  5.509360 0.1954937  6.736502 0.2007150 181180 333740    1
#  # 2  2  5.546006 0.1716895  6.785460 0.1749260 181140 333700    1
#  # 3  3  5.488913 0.1784052  6.698883 0.1826314 181180 333700    1
#  # 4  4  5.388320 0.1855561  6.558216 0.1906426 181220 333700    1
#  # 5  5  5.584415 0.1463018  6.841612 0.1465346 181100 333660    1
#  # 6  6  5.525538 0.1533757  6.749216 0.1549663 181140 333660    1

## ---- eval = FALSE,echo=TRUE, message=FALSE, warning=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(SamplingStrata)
#  frame <- buildFrameSpatial(df=df,
#                        id="id",
#                        X=c("lead.pred","zinc.pred"),
#                        Y=c("lead.pred","zinc.pred"),
#                        variance=c("lead.var","zinc.var"),
#                        lon="lon",
#                        lat="lat",
#                        domainvalue = "dom1")
#  #  id       X1       X2       Y1       Y2      var1      var2    lon    lat domainvalue
#  # 1  1 5.509360 6.736502 5.509360 6.736502 0.1954937 0.2007150 181180 333740           1
#  # 2  2 5.546006 6.785460 5.546006 6.785460 0.1716895 0.1749260 181140 333700           1
#  # 3  3 5.488913 6.698883 5.488913 6.698883 0.1784052 0.1826314 181180 333700           1
#  # 4  4 5.388320 6.558216 5.388320 6.558216 0.1855561 0.1906426 181220 333700           1
#  # 5  5 5.584415 6.841612 5.584415 6.841612 0.1463018 0.1465346 181100 333660           1
#  # 6  6 5.525538 6.749216 5.525538 6.749216 0.1533757 0.1549663 181140 333660           1

## ---- eval = FALSE,echo=TRUE, message=FALSE, warning=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  cv <- as.data.frame(list(DOM=rep("DOM1",1),
#                           CV1=rep(0.01,1),
#                           CV2=rep(0.01,1),
#                           domainvalue=c(1:1) ))
#  cv
#  #    DOM  CV1  CV2 domainvalue
#  # 1 DOM1 0.01 0.01           1

## ---- eval = FALSE,echo=TRUE, message=FALSE, warning=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  set.seed(1234)
#  solution <- optimStrata (
#    method = "spatial",
#    errors=cv,
#    framesamp=frame,
#    iter = 15,
#    pops = 10,
#    nStrata = 5,
#    fitting = c(summary(lm_lead)$r.square,summary(lm_zinc)$r.square),
#    range = c(kriging_lead$var_model$range[2],kriging_zinc$var_model$range[2]),
#    kappa=1)
#  
#  # *** Domain :  1   1
#  #  Number of strata :  3103
#  # GA Settings
#  #   Population size       = 10
#  #   Number of Generations = 15
#  #   Elitism               = 2
#  #   Mutation Chance       = 0.111111111111111
#  #
#  #
#  #
#  #  *** Sample cost:  79.87774
#  #  *** Number of strata:  4
#  #  *** Sample size :  80
#  #  *** Number of strata :  4
#  # ---------------------------
#  

## ---- eval = FALSE,echo=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  plotStrata2d(solution$framenew,
#               solution$aggr_strata,
#               domain=1,
#               vars=c("X1","X2"),
#               labels=c("Lead","Zinc"))

## ---- eval = FALSE,echo=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  frameres <- SpatialPointsDataFrame(data=framenew, coords=cbind(framenew$LON,framenew$LAT) )
#  frameres2 <- SpatialPixelsDataFrame(points=frameres[c("LON","LAT")], data=framenew)
#  frameres2$LABEL <- as.factor(frameres2$LABEL)
#  spplot(frameres2,c("LABEL"), col.regions=bpy.colors(5))

## ---- eval = FALSE,echo=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  s <- selectSample(solution$framenew,
#                    solution$aggr_strata)
#  
#  # *** Sample has been drawn successfully ***
#  #  80  units have been selected from  4  strata

## ---- eval = FALSE,echo=FALSE,message=FALSE,fig.width=6, fig.height=8----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  plot(s$LON[s$LABEL==1],s$LAT[s$LABEL==1],col="black",
#       xlab="longitude",ylab="latitude",
#       xlim=c(min(s$LON),max(s$LON)),
#       ylim=c(min(s$LAT),max(s$LAT)))
#  text(s$LON[s$LABEL==1],s$LAT[s$LABEL==1], labels = row.names(s[s$LABEL == 1,]), pos = 2, cex=0.6)
#  points(s$LON[s$LABEL==2],s$LAT[s$LABEL==2],col="blue")
#  text(s$LON[s$LABEL==2],s$LAT[s$LABEL==2], labels = row.names(s[s$LABEL == 2,]), pos = 4, cex=0.6, col="blue")
#  points(s$LON[s$LABEL==3],s$LAT[s$LABEL==3],col="magenta")
#  text(s$LON[s$LABEL==3],s$LAT[s$LABEL==3], labels = row.names(s[s$LABEL == 3,]), pos = 3, cex=0.6, col="darkorange")
#  points(s$LON[s$LABEL==4],s$LAT[s$LABEL==4],col="darkorange")
#  text(s$LON[s$LABEL==4],s$LAT[s$LABEL==4], labels = row.names(s[s$LABEL == 4,]), pos = 1, cex=0.6, col="yellow")
#  # points(s$LON[s$LABEL==5],s$LAT[s$LABEL==5],col="red")
#  # text(s$LON[s$LABEL==5],s$LAT[s$LABEL==5], labels = row.names(s[s$LABEL == 5,]), pos = 4, cex=0.6, col="red")
#  title("Selected units")
#  

