% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_Shapefile.R
\name{Get_Shapefile}
\alias{Get_Shapefile}
\title{Download the shapefiles of Italian NUTS-3 and LAU administrative units}
\source{
<https://www.istat.it/it/archivio/222527>
}
\usage{
Get_Shapefile(
  Year,
  level = "LAU",
  lightShp = TRUE,
  autoAbort = FALSE,
  centroids = FALSE
)
}
\arguments{
\item{Year}{Numeric. Reference year for the administrative units.}

\item{level}{Character. Either  \code{"NUTS-4"/"LAU"/"Municipality"}, \code{"NUTS-3"/"Province"},  \code{"NUTS-2"/"Region"}, . \code{"LAU"} by default}

\item{lightShp}{Logical. If \code{TRUE}, the function downloads a generalised, i.e.less detailed, and lighter version of the shapefiles.
\code{TRUE} by default.}

\item{autoAbort}{Logical. Whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}

\item{centroids}{Logical. Whether to switch from polygon geometry to point geometry. In the latter case, the point is located at the centroid of the relevant area. \code{FALSE} by default.}
}
\value{
A spatial data frame of class \code{data.frame} and \code{sf}.
}
\description{
Downloads either the boundaries or the centroids of the relevant administrative units,
either provinces or municipalities, from the ISTAT website. Geometries are expressed in meters.
}
\examples{

\donttest{
  library(magrittr)


  Prov23_shp <- Get_Shapefile(2023, lightShp = TRUE, level = "NUTS-3", autoAbort = TRUE)
  ggplot2::ggplot() + ggplot2::geom_sf(data = Prov23_shp) +
    ggplot2::ggtitle("Italian provinces in 2023/01/01")
 }


}
