% Generated by roxygen2 (4.0.2): do not edit by hand
\name{outliers}
\alias{outliers}
\title{Detect Outliers}
\usage{
outliers(x, index = NULL)
}
\arguments{
\item{x}{A numeric object}

\item{index}{A numeric value to be considered in the computations}
}
\value{
The returning object will depend on the inputing object, either a vector or a data frame.
}
\description{
Perform an exploaratory test to detect \emph{outliers}. This function returns the minimum and maximum values, respectively preceded by their positions in the \code{vector}, \code{matrix} or \code{data.frame}. The quantity for \emph{min} reveals the minimum deviation from the mean, the integer in \emph{closest} highlights the position of the element. In the same vein, the quantity for \emph{max} is the maximum deviation from the mean, and the \code{farthest} integer is the position of such higher quantity.
}
\examples{
outliers(x <- rnorm(20))

#data frame:
data(ssex)
outliers(ssex)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Dixon, W.J. (1950) Analysis of extreme values. \emph{Ann. Math. Stat.} \bold{21(4),} 488--506.
}
\seealso{
\link{winsorize} for diminishing the impact of outliers.
}

