% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagrams.R
\name{ROC_curve}
\alias{ROC_curve}
\title{ROC curve for tercile forecasts}
\usage{
ROC_curve(
  dt,
  f = c("below", "normal", "above"),
  o = tc_cols(dt),
  by = NULL,
  pool = setdiff(dimvars(dt), by),
  interpolate = TRUE,
  dim.check = TRUE
)
}
\arguments{
\item{dt}{Data table containing tercile forecasts}

\item{f}{column names of the prediction columns}

\item{o}{column name of the observation column}

\item{by}{column names of grouping variables. Default is to not group.}

\item{pool}{column names of pooling variables (used for the dimension check). Default is all dimvars.}

\item{interpolate}{Logical. If TRUE, the curve connects the dots making up the ROC curve (which looks nicer), if not a step function is drawn (which is closer to the mathematical definition of the ROC curve).}

\item{dim.check}{Logical. If TRUE, the function checks whether the columns in by and pool span the entire data table.}
}
\value{
A list of gg objects which can be plotted by \code{ggpubr::ggarrange} (for example)
}
\description{
Creates ROC curves from a data table containing tercile forecasts. It wraps \code{roc_curve_vec}.
By default, 4 ROC-curves are drawn, one for each the prediction of above-, normal- and below-values, plus one for all forecasts together.
You can provide a 'by' argument to obtain separate ROC-curves for different values of the by-columns. E.g., when your data table contains
a column named 'season', you can set by = 'season'. Then, the function will output a list of 16 ROC-curvess, 4 for each season.
}
\examples{
dt = data.table(below = c(0.5,0.3,0),
                normal = c(0.3,0.3,0.7),
                above = c(0.2,0.4,0.3),
                tc_cat = c(-1,0,0),
                lon = 1:3)
print(dt)
pp = ROC_curve(dt)
if(interactive()) plot(pp)

}
