\name{trXX_dXX}
\alias{trXX_dXX}

\alias{trXX_d10}
\alias{tr01_d10}
\alias{tr10_d10}
\alias{tr11_d10}
\alias{tr12_d10}
\alias{tr17_d10}
\alias{tr18_d10}
\alias{tr23_d10}
\alias{tr24_d10}
\alias{tr25_d10}
\alias{tr28_d10}
\alias{tr33_d10}
\alias{tr36_d10}
\alias{tr37_d10}
\alias{tr39_d10}
\alias{tr42_d10}
\alias{tr44_d10}
\alias{tr45_d10}
\alias{tr47_d10}
\alias{tr50_d10}
\alias{tr51_d10}
\alias{tr54_d10}
\alias{tr55_d10}
\alias{tr72_d10}

\docType{data}
\title{
   Provides the U.S. 2000 Census Tract Boundary data datasets for 23
   States East of the Mississippi River for use with 
   \var{SeerMapper} Package
}
\description{
 There are six supplemental census tract boundary packages for 
 use with \var{SeerMapper}.  The are \var{SeerMapperRegs},
 \var{SeerMapperEast}, and \var{SeerMapperWest} for the 2000 census and 
 \var{Seer2010MapperRegs}, \var{Seer2010MapperEast} and 
 \var{SeerMapper2010West} for the 2010 census. The combination of the 
 either three provide a set of census tract boundaries for one U. S. 
 census year (either 2000 or 2010). The \var{SeerMapperRegs} and 
 \var{Seer2010MapperRegs} packages contain the census tract 
 boundaries for the 15 states the have U. S. Seer Registries. The 
 remaining census tract boundaries are split into two packages for 
 each census year based on whether the state is east or west of the 
 Mississippi river.  The census tracts for 23 states without 
 registries east of the Mississippi river at contained in the 
 \var{SeerMapperEast} and \var{Seer2010MapperEast} packages. The 
 tract boundaries for the 14 states west of the Mississippi river are 
 in the \var{SeerMapperWest} and \var{Seer2010MapperWest} packages.  
 The states include the District of Columbia and Puerto Rico.
 This package provides the 2010 census tract boundaries for the 23 
 states without registries east of the Mississippi river.
 }
\usage{data(tr01_d10)}
\format{
 Each file contains a set of SpatialPolygons structures for the 23 states
 east of the Mississippi that do not have Seer Registries.
 Each state structure is a list of the census tracts boundaries that 
 the state. Refer to the documentation on the \var{sp} package for 
 details on the strucures.  Each list element is a "polygons" class 
 structure containing attributes of the census tract (label point, 
 area, ID, etc.) and a list of "Polygons" class elements that define 
 the boundary polygons.
}
\details{
  The \var{SeerMapperEast} and \var{SeerMapper2010East} packages contains 
  23 eastern states including:
  \preformatted{
    FIPS   Name
     01     Alabama
     10     Delaware
     11	    District of Columbia
     12	    Florida
     17	    Illinois
     18	    Indiana
     23     Maine
     24     Maryland
     25     Massachusetts
     28	    Mississippi
     33	    New Hampshire
     36	    New York
     37	    North Carolina
     39	    Ohio
     42     Pennsylvania
     44	    Rhode Island
     45	    South Carolina
     47	    Tennessee
     50	    Vermont
     51	    Virginia
     54     West Virginia
     55	    Wisconsin
     72	    Puerto Rico
  }
 The \var{SeerMapper} package contains the state and county boundary 
 data for all 51 states and DC and the Seer Registry boundary data for 
 the 20 established registries.  Due to space limitations, the base 
 packages cannot contain the census tract boundary data.
 
 Three supplemental data packages are used for each census year to 
 provide the census tract boundary data to \var{SeerMapper} package.  
 
 Each state ".rda" file (dataset) contains state's census tract 
 boundary data. The file name structure is trXX_dYY, where tr 
 identifies the file as census tract boundary data, "XX" is the state 
 (2 digits) fips code and "YY" represents the census year (e.g., 00 = 
 2000 or 10 for 2010)

 To conserve disk space and downloading/installation time, the rda 
 files are compressed using the "xy" method.
 
 The U. S. Census Bureau census tract boundary shape file data was pre-
 processed by "www.MapShaper.org" website version 01.15 using modified 
 Visvalingam method with the intersection repair and prevent shape 
 removal options enabled, the coordinate precision value set to 0.0 and 
 the simplify parameter set to 10%. This reduces the space requirements 
 by 85% while maintaining a reasonable boundary image and edge 
 alignments.
 
 When the \var{SeerMapper} package is install, the six (6) census tract
 boundary supplement packages are also install automatically by R.
 The \var{SeerMapper} package then manages the loading of the packages 
 to ensure the needed boundary files are available.
}
\source{
 The census tract boundary shapefiles were downloaded from the 
 CENSUS.GOV web site for the 2010 Census census tract boundary shapefiles, 
 https://www2.census.gov/geo/tiger/GENZ2010/gz_2010_XX_140_00_500k.zip, 
 where XX is the state FIPS code.  
}
\examples{
  #
  #  These examples are a test to ensure each census tract file
  #  can be read and a plot of the state generated.
  #
  require("sp")

  #
  #  If you want to save and see the example output PDF files, change the 
  #  the following "tempDir()" to the path you want to save the output files.
  #                For Example:   outDir <- "c:/RTestPDFs"
  outDir     <- tempdir()
  cat("Output Directory:",outDir,"\n")
  
  stList     <- c("01","10","11","12","17",
                  "18","23","24","25","28",
                  "33","36","37","39","42",
                  "44","45","47","50","51",
                  "54","55","72"
                 )
  stName     <- c("Alabama","Delaware","Dist.of Columbia","Florida","Illinois",
                  "Indiana","Maine","Maryland","Massachusetts","Mississippi",
                  "New Hampshire","New York","North Carolina","Ohio","Pennsylvania",
                  "Rhode Island","South Carolina","Tennessee","Vermont","Virginia",
                  "West Virginia","Wisconsin","Puerto Rico"
                )
  cY         <- "10"

  outFile    <- paste0("SeerMapperEast",cY,"-CT.pdf")
  outFN      <- file.path(outDir,outFile)
  cat("Output example PDF file:",outFN,"\n")
  
  pdf(outFN,width=7,height=10)

  for (stN in seq(from=1, to=length(stList), by=8)) {  # Test print 3 of 23 states.

     stID    <- stList[stN]
     stNa    <- stName[stN]
     trFN    <- paste0("tr",stID,"_d",cY)
     TT_tr   <- paste0("U. S. Census Tracts - ",stNa,"  Fips=",stID,"  file=",trFN)
     
     data(list=trFN)
     
     wrSP    <- get(trFN)
     #str(wrSP)
     
     plot(wrSP,main=TT_tr)
     rm(list=trFN)
  }

  dev.off()
}
\keyword{Census2000}
\keyword{Census2010}
\keyword{datasets}
