% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/org.plot.R
\name{org.plot}
\alias{org.plot}
\title{Organization function for partboot.plot}
\usage{
org.plot(input, len, measures, name, groups, netmeas)
}
\arguments{
\item{input}{List.
Input data from \link[SemNeT]{partboot}}

\item{len}{Numeric.
Number of bootstrapped samples (percentages)}

\item{measures}{Character.
Network measures to be entered}

\item{name}{Character.
Name(s) of object(s) used from \link[SemNeT]{partboot}}

\item{groups}{Character.
Names for the group(s)}

\item{netmeas}{Character.
Abbreviated network measure name that should be plotted}
}
\value{
Returns plots for the specified measures
}
\description{
A wrapper function used in \link[SemNeT]{partboot}. Not to be used individually
}
\examples{
#### NOT INTENDED FOR INDIVIDUAL USE ####
#### WRAPPER FUNCTION ####

# Simulate Dataset
one <- sim.fluency(20)
\donttest{
# Run partial bootstrap networks
one.result <- partboot(data = one, percent = .50, iter = 1000,
sim = "cosine", cores = 2)
}
# Plot
org.plot(input = list(one.result), name = "data",
len = 1, groups = "One", netmeas = "ASPL")

}
\references{
Allen, M., Poggiali, D., Whitaker, K., Marshall, T. R., Kievit, R. (2018).
Raincloud plots: A multi-platform tool for robust data visualization.
\emph{PeerJ Preprints}, \emph{6}, e27137v1.
\href{https://doi.org/10.7287/peerj.preprints.27137v1}{10.7287/peerj.preprints.27137v1}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
