% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootSemNeT.R
\name{bootSemNeT}
\alias{bootSemNeT}
\title{Bootstrapped Semantic Network Analysis}
\usage{
bootSemNeT(
  ...,
  method = c("CN", "NRW", "PF", "TMFG"),
  methodArgs = NULL,
  type = c("case", "node"),
  prop = 0.5,
  sim,
  weighted = FALSE,
  iter = 1000,
  cores
)
}
\arguments{
\item{...}{Matrices or data frames.
Cleaned response matrices (e.g., \code{responses$clean} from
\code{\link[SemNetCleaner]{textcleaner}}) or  binary response matrices
(e.g., \code{binary} output from \code{\link[SemNetCleaner]{textcleaner}})}

\item{method}{Character.
Network estimation method to use.
Current options include:

\itemize{
\item{\code{\link[NetworkToolbox]{TMFG}}}
{Triangulated Maximally Filtered Graph}

\item{\code{\link[SemNeT]{CN}}}
{Community Network}

\item{\code{\link[SemNeT]{NRW}}}
{Naive Random Walk}

\item{\code{\link[SemNeT]{PF}}}
{Pathfinder}

}}

\item{methodArgs}{List.
A list of additional arguments for the network estimation function.
See links in \code{methods} for additional arguments (see also Examples)}

\item{type}{Character.
Type of bootstrap to perform

\itemize{
\item{\code{node}}
{Generates partial networks based on dropping a certain
proportion of nodes (see argument \code{prop})}

\item{\code{case}}
{Samples with replacement the same number of participants
as in the original dataset}
}}

\item{prop}{Numeric.
\strong{Only} for \code{type = "node"}.
Proportion of nodes to remain in the network.
Defaults to \code{.50}}

\item{sim}{Character.
Similarity measure to use.
Defaults to \code{"cosine"}.
See \code{\link[SemNeT]{similarity}} for other options}

\item{weighted}{Boolean.
Should weighted ASPL and CC be used?
Defaults to \code{FALSE}.
Set to \code{TRUE} for weighted ASPL and CC}

\item{iter}{Numeric.
Number of iterations in bootstrap.
Defaults to \code{1000}}

\item{cores}{Numeric.
Number of computer processing cores to use for bootstrapping samples.
Defaults to \emph{n} / 2 total number of cores.
Set to any number between 1 and maximum amount of cores on your computer
(see \code{parellel::detectCores()})}
}
\value{
Returns a list containing:

\item{dataMeas}{A matrix for the network input in the \code{data}
argument, where columns are the semantic network measures
from \code{\link[SemNeT]{semnetmeas}} and rows are their values from each
bootstrapped sample (results in a matrix with the dimensions \code{iter} by 3)}

\item{dataSumm}{Summary statistics across the bootrapped samples for the
network input in the \code{data} argument}

\item{prop}{Outputs the proportion used from the \code{prop} argument}

\item{iter}{Outputs the number of bootstrapped samples
used from the \code{iter} argument}

If a \code{paired} network is input, then also returns:

\item{pairedMeas}{A matrix for the network input in the \code{paired}
argument, where columns are the semantic network measures
from \code{\link[SemNeT]{semnetmeas}} and rows are their values from each
bootstrapped sample (results in a matrix with the dimensions \code{iter} by 3)}

\item{pairedSumm}{Summary statistics across the bootrapped samples for the
network input in the \code{paired} argument}
}
\description{
Bootstrap techniques to generate
semantic networks and compute global network characteristics
}
\examples{
# Simulate Dataset
one <- sim.fluency(20)
\donttest{
# Run bootstrap node-drop (partial) networks
one.result <- bootSemNeT(one, prop = .50, iter = 100,
sim = "cosine", cores = 2, method = "TMFG", type = "node")

# Run bootstrap case-drop networks
## Includes additional equating argument: minCase
one.result <- bootSemNeT(one, iter = 100, sim = "cosine",
cores = 2, method = "TMFG", type = "case", methodArgs = list(minCase = 2))

}
# Bootstrap case-wise networks
## Get openness data
low <- open.clean[which(open.group == "Low"),]
high <- open.clean[which(open.group == "High"),]
\donttest{
## Run
### Inlcudes additional NRW argument: threshold
open <- bootSemNeT(low, high, iter = 100, cores = 2, method = "NRW", type = "case",
methodArgs = list(threshold = 3))

}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
