% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2igraph.R
\name{convert2igraph}
\alias{convert2igraph}
\title{Convert Network(s) to igraph's Format}
\usage{
convert2igraph(A, neural = FALSE)
}
\arguments{
\item{A}{Adjacency matrix (network matrix) or brain connectivity array
(from \code{\link[NetworkToolbox]{convertConnBrainMat}})}

\item{neural}{Defunct.}
}
\value{
Returns a network matrix in \code{\link{igraph}}'s format
}
\description{
Converts single or multiple networks into \code{\link{igraph}}'s format for network analysis
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(similarity(sim.fluency(50), method = "cor"))

igraphNetwork <- convert2igraph(A)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
