% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.monikers.R
\name{load.monikers}
\alias{load.monikers}
\title{Load Monikers}
\usage{
load.monikers(moniker)
}
\arguments{
\item{moniker}{Character vector.
monikers to load (must be a dictionary in
\code{\link[SemNetDictionaries]{dictionaries}})}
}
\value{
Returns a vector of unique words that have been combined
and alphabetized from the specified monikers
}
\description{
A wrapper function to load monikers into
the 'SemNetCleaner' package. Searches for monikers in \code{R}'s
 \code{\link{SemNetDictionaries}} package. Outputs a unique word list
that is combined from all dictionaries entered in the \code{moniker} argument
}
\examples{
#find dictionaries to load
dictionaries()

#load "animals" monikers
load.monikers("animals")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
