% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SentimentDictionary.R
\name{numEntries}
\alias{numEntries}
\title{Number of words in dictionary}
\usage{
numEntries(d)
}
\arguments{
\item{d}{Dictionary of type \code{\link{SentimentDictionaryWordlist}},
\code{\link{SentimentDictionaryBinary}} or
\code{\link{SentimentDictionaryWeighted}}}
}
\description{
Counts total number of entries in dictionary.
}
\examples{
numEntries(SentimentDictionary(c("uncertain", "possible", "likely"))) # returns 3
numEntries(SentimentDictionary(c("increase", "rise", "more"),
                            c("fall", "drop"))) # returns 5
numEntries(SentimentDictionary(c("increase", "decrease", "exit"),
                               c(+1, -1, -10),
                               rep(NA, 3))) # returns 3
}
\seealso{
\code{\link{numPositiveEntries}} and 
\code{\link{numNegativeEntries}} for more option to count the number of entries
}
\keyword{dictionary}
