% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoscape.R
\name{create_cytoscape_file}
\alias{create_cytoscape_file}
\title{Create an edge table file for Cytoscape}
\usage{
create_cytoscape_file(g)
}
\arguments{
\item{g}{A 'network_plot' object. See \code{\link{plot_network}}.}
}
\value{
A data frame containing an edge table that can be saved as a .csv file
to be used in Cytoscape.
}
\description{
The returned data frame can be saved as a .csv file. Then, in Cytoscape use
File -> Import -> Network -> File. Select the .csv file containing the data
frame generated by this function. There will be a pop-up window. The source,
interaction, and target columns should automatically be identified. Click OK.
}
\examples{
nw <- random_network(10)
g <- plot(nw)
nw_plot_cytoscape <- create_cytoscape_file(g)
\donttest{
# Save the edge table in a .csv file to be used in cytoscape.
write.table(nw_plot_cytoscape, file.path(tempdir(), "file_name.csv"), 
            sep = ",", row.names = FALSE, col.names = TRUE, quote = FALSE)
}
}
